/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.line;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.line.LineLayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class LineChart
extends AbstractChartCustomGraphics<LineLayer> {
    private static final String COLORS = "colorlist";
    private static final String LINEWIDTH = "linewidth";
    private List<Color> colorList = null;
    private int labelSize = 4;
    private String colorString = null;
    private float lineWidth = 1.5f;

    public LineChart(String input) {
        Map<String, String> args = this.parseInput(input);
        this.populateValues(args);
        if (args.containsKey(COLORS)) {
            this.colorString = args.get(COLORS);
            if (this.attributes == null) {
                this.colorList = this.convertInputToColor(this.colorString, this.values);
            }
        }
        if (args.containsKey(LINEWIDTH)) {
            this.lineWidth = Float.parseFloat(args.get(LINEWIDTH));
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<LineLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        CyNode node = (CyNode)nodeView.getModel();
        if (this.attributes != null && this.attributes.size() > 0) {
            this.values = this.getDataFromAttributes(network, node, this.attributes, this.labels);
            this.colorList = this.convertInputToColor(this.colorString, this.values);
        }
        this.layers = new ArrayList();
        ArrayList labelList = new ArrayList();
        double minValue = 1.0E-6;
        double maxValue = -minValue;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            minValue = Math.min(minValue, val);
            maxValue = Math.max(maxValue, val);
        }
        boolean scalingColor = false;
        String[] colorArray = this.colorString.split(",");
        if (colorArray.length == 2 && (colorArray[0].toLowerCase().startsWith("up:") || colorArray[0].toLowerCase().startsWith("down:"))) {
            scalingColor = true;
        } else if (colorArray.length == 3 && (colorArray[0].toLowerCase().startsWith("up:") || colorArray[0].toLowerCase().startsWith("down:") || colorArray[0].toLowerCase().startsWith("zero:"))) {
            scalingColor = true;
        } else if (colorArray.length == 4 && (colorArray[0].toLowerCase().startsWith("up:") || colorArray[0].toLowerCase().startsWith("down:") || colorArray[0].toLowerCase().startsWith("zero:") || colorArray[0].toLowerCase().startsWith("missing:"))) {
            scalingColor = true;
        }
        int nPoints = this.values.size();
        if (scalingColor) {
            ArrayList<Double> scalingValues = new ArrayList<Double>();
            for (int point = 0; point < nPoints - 1; ++point) {
                scalingValues.add((Double)this.values.get(point + 1) - (Double)this.values.get(point));
            }
            double saved_rangeMin = this.rangeMin;
            double saved_rangeMax = this.rangeMax;
            this.rangeMin = 0.0;
            this.rangeMax = 0.0;
            this.colorList = this.convertInputToColor(this.colorString, scalingValues);
            this.rangeMin = saved_rangeMin;
            this.rangeMax = saved_rangeMax;
        }
        for (int point = 0; point < nPoints - 1; ++point) {
            LineLayer bl;
            Color color = this.colorList.get(0);
            if (point < this.colorList.size()) {
                color = this.colorList.get(point);
            }
            if ((bl = new LineLayer(point, nPoints, (Double)this.values.get(point), (Double)this.values.get(point + 1), minValue, maxValue, color, this.lineWidth)) == null) continue;
            this.layers.add(bl);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }
}

