/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.label;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public class LabelLayer
implements PaintedShape {
    private String label;
    private Color color;
    private double maxWidth;
    private double lineSpacing = 1.0;
    private ViewUtils.TextAlignment labelAlignment;
    private Color outlineColor;
    private Font font;
    private boolean shadow;
    private boolean outline;
    private boolean rescale;
    private double angle;
    private double outlineWidth;
    private float strokeSize;
    protected Rectangle2D bounds;
    protected Rectangle2D nodeBox;
    private Shape labelShape;
    private Object position;
    private Object anchor;
    private Point2D offset;
    private double paddingScale;

    public LabelLayer(String label, Rectangle2D bbox, Object position, Object anchor, Point2D offset, Font font, ViewUtils.TextAlignment labelAlignment, Color labelColor, Color outlineColor, double outlineWidth, boolean shadow, boolean outline, double angle, boolean rescale, double maxWidth, double lineSpacing, double padding) {
        this.label = label;
        this.font = font;
        this.labelAlignment = labelAlignment;
        this.color = labelColor;
        this.nodeBox = bbox;
        this.position = position;
        this.anchor = anchor;
        this.offset = offset;
        this.outlineColor = outlineColor;
        this.outlineWidth = outlineWidth;
        this.shadow = shadow;
        this.rescale = rescale;
        this.maxWidth = maxWidth;
        this.lineSpacing = lineSpacing;
        this.paddingScale = padding;
        this.outline = outline;
        this.angle = angle;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 50.0, 50.0);
        if (outline && outlineColor == null) {
            outlineColor = Color.BLACK;
        }
        if (outline) {
            this.strokeSize = (float)outlineWidth * font.getSize2D() / 20.0f;
        }
        this.labelShape = this.labelShape();
    }

    public LabelLayer copy() {
        LabelLayer copy = new LabelLayer(this.label, this.nodeBox, this.position, this.anchor, this.offset, this.font, this.labelAlignment, this.color, this.outlineColor, this.outlineWidth, this.shadow, this.outline, this.angle, this.rescale, this.maxWidth, this.lineSpacing, this.paddingScale);
        return copy;
    }

    public Paint getPaint() {
        return this.color;
    }

    public Paint getPaint(Rectangle2D bounds) {
        return this.color;
    }

    public Shape getShape() {
        return this.labelShape;
    }

    public Stroke getStroke() {
        if (this.outline) {
            return new BasicStroke(this.strokeSize, 1, 1);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return this.outlineColor;
    }

    public Rectangle2D getBounds2D() {
        return this.getShape().getBounds2D();
    }

    public LabelLayer transform(AffineTransform xform) {
        this.bounds = xform.createTransformedShape(this.bounds).getBounds2D();
        this.labelShape = ViewUtils.createPossiblyTransformedShape(xform, this.labelShape, this.rescale);
        return this;
    }

    private Shape positionLabel(Shape lShape, Point2D position, ViewUtils.TextAlignment tAlign, double padding) {
        double textWidth = lShape.getBounds2D().getWidth();
        double textHeight = lShape.getBounds2D().getHeight();
        double pointX = position.getX();
        double pointY = position.getY();
        double textStartX = pointX;
        double textStartY = pointY;
        switch (tAlign) {
            case ALIGN_CENTER: 
            case ALIGN_CENTER_TOP: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY + padding;
                break;
            }
            case ALIGN_CENTER_BOTTOM: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY - textHeight - padding;
                break;
            }
            case ALIGN_RIGHT: {
                textStartX = pointX - textWidth - padding;
                textStartY = pointY + padding;
                break;
            }
            case ALIGN_LEFT: {
                textStartX = pointX + padding;
                textStartY = pointY + padding;
                break;
            }
            case ALIGN_MIDDLE: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY - textHeight / 2.0;
                break;
            }
        }
        if (this.offset != null) {
            textStartX += this.offset.getX();
            textStartY += this.offset.getY();
        }
        AffineTransform trans = new AffineTransform();
        trans.translate(textStartX, textStartY);
        return trans.createTransformedShape(lShape);
    }

    private Shape labelShape() {
        double pad = this.nodeBox.getWidth() * this.paddingScale;
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.maxWidth - 2.0 * pad, this.lineSpacing);
        AffineTransform replaceTrans = new AffineTransform();
        replaceTrans.translate(-textShape.getBounds2D().getX(), -textShape.getBounds2D().getY());
        textShape = replaceTrans.createTransformedShape(textShape);
        Rectangle2D textBounds = textShape.getBounds2D();
        Point2D textBox = ViewUtils.positionAdjust(this.nodeBox, textBounds, this.position, this.anchor);
        if (textBox == null) {
            textBox = new Point2D.Double(0.0, 0.0);
        }
        if ((textShape = this.positionLabel(textShape, textBox, this.labelAlignment, pad)) == null) {
            return null;
        }
        if (this.shadow) {
            textBounds = textShape.getBounds2D();
            RoundRectangle2D.Double shadow = new RoundRectangle2D.Double(textBounds.getX() - pad, textBounds.getY() - pad, textBounds.getWidth() + pad * 2.0, textBounds.getHeight() + pad * 2.0, pad * 2.0, pad * 2.0);
            return shadow;
        }
        return textShape;
    }
}

