/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.label;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ShadowLayer;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.label.LabelLayer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class Label
extends AbstractChartCustomGraphics<CustomGraphicLayer> {
    private static final String COLOR = "color";
    private static final String ANGLE = "angle";
    private static final String ATTRIBUTE = "attribute";
    private static final String BACKGROUND = "background";
    private static final String BGCOLOR = "bgColor";
    private static final String DROPSHADOW = "dropShadow";
    private static final String LABEL = "label";
    private static final String LABELALIGNMENT = "labelAlignment";
    private static final String OUTLINE = "outline";
    private static final String OUTLINECOLOR = "outlineColor";
    private static final String OUTLINETRANS = "outlineTransparency";
    private static final String OUTLINEWIDTH = "outlineWidth";
    private static final String PADDING = "padding";
    private static final String RESCALE = "rescale";
    private Color color = null;
    private double labelAngle = 0.0;
    private String labelAttribute = null;
    private String label = null;
    private ViewUtils.TextAlignment labelAlignment = ViewUtils.TextAlignment.ALIGN_MIDDLE;
    private boolean background = false;
    private Color bgColor = null;
    private boolean dropShadow = false;
    private boolean outlineLabel = false;
    private Color outlineColor = null;
    private double outlineWidth = 0.0;
    private boolean rescale = false;
    private double padding = 0.0;

    public Label(String input) {
        String lavelAlignArg;
        Map<String, String> args = this.parseInput(input);
        this.populateValues(args);
        if (args.containsKey(COLOR)) {
            this.color = this.parseColor(args.get(COLOR));
        }
        if (args.containsKey(ATTRIBUTE)) {
            this.labelAttribute = args.get(ATTRIBUTE);
        }
        if (args.containsKey(LABEL)) {
            this.label = args.get(LABEL);
        }
        if (args.containsKey(LABELALIGNMENT) && ViewUtils.textAlignmentMapping.containsKey(lavelAlignArg = args.get(LABELALIGNMENT))) {
            this.labelAlignment = ViewUtils.textAlignmentMapping.get(lavelAlignArg);
        }
        if (args.containsKey(DROPSHADOW)) {
            this.dropShadow = this.getBooleanValue(args.get(DROPSHADOW));
        }
        if (args.containsKey(BACKGROUND)) {
            this.background = this.getBooleanValue(args.get(BACKGROUND));
        }
        if (args.containsKey(RESCALE)) {
            this.rescale = this.getBooleanValue(args.get(RESCALE));
        }
        if (args.containsKey(BGCOLOR)) {
            this.bgColor = this.parseColor(args.get(BGCOLOR));
            if (this.bgColor.getAlpha() == 255) {
                this.bgColor = new Color(this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), 125);
            }
        } else {
            this.bgColor = new Color(255, 255, 255, 125);
        }
        if (args.containsKey(OUTLINE)) {
            this.outlineLabel = this.getBooleanValue(args.get(OUTLINE));
        }
        if (args.containsKey(OUTLINECOLOR)) {
            this.outlineColor = this.parseColor(args.get(OUTLINECOLOR));
        }
        if (args.containsKey(OUTLINETRANS)) {
            if (this.outlineColor == null) {
                this.outlineColor = this.parseColor(args.get(OUTLINECOLOR));
            }
            int transp = this.getIntegerValue(args.get(OUTLINETRANS));
            this.outlineColor = new Color(this.outlineColor.getRed(), this.outlineColor.getGreen(), this.outlineColor.getBlue(), transp);
        }
        if (args.containsKey(OUTLINEWIDTH)) {
            this.outlineWidth = this.getDoubleValue(args.get(OUTLINEWIDTH));
        }
        if (args.containsKey(ANGLE)) {
            this.labelAngle = this.getDoubleValue(args.get(ANGLE));
        }
        if (args.containsKey(PADDING)) {
            this.padding = this.getDoubleValue(args.get(PADDING));
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<CustomGraphicLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        this.layers = new ArrayList();
        CyNode node = (CyNode)nodeView.getModel();
        double nodeWidth = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
        double nodeHeight = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
        Rectangle2D.Double initialBox = new Rectangle2D.Double(0.0, 0.0, nodeWidth, nodeHeight);
        if (this.color == null) {
            this.color = Color.BLACK;
        }
        if (this.labelAttribute != null) {
            this.label = this.getLabelFromAttribute(network, node, this.labelAttribute);
        }
        Font font = this.getFont();
        ArrayList<CustomGraphicLayer> labelLayers = new ArrayList<CustomGraphicLayer>();
        if (this.label != null && this.label.length() > 0) {
            LabelLayer bgLayer;
            LabelLayer labelLayer = new LabelLayer(this.label, initialBox, this.position, this.anchor, this.labelOffset, font, this.labelAlignment, this.color, this.outlineColor, this.outlineWidth, false, this.outlineLabel, this.labelAngle, this.rescale, this.labelWidth, this.labelSpacing, this.padding);
            if (this.background && (bgLayer = new LabelLayer(this.label, initialBox, this.position, this.anchor, this.labelOffset, font, this.labelAlignment, this.bgColor, this.outlineColor, this.outlineWidth, true, false, this.labelAngle, this.rescale, this.labelWidth, this.labelSpacing, this.padding)) != null) {
                labelLayers.add((CustomGraphicLayer)bgLayer);
            }
            if (this.dropShadow) {
                double offset = (double)font.getSize2D() / 15.0;
                ShadowLayer shadowLayer = new ShadowLayer(labelLayer.getShape(), offset, this.rescale);
                labelLayers.add((CustomGraphicLayer)shadowLayer);
            }
            if (labelLayer != null) {
                labelLayers.add((CustomGraphicLayer)labelLayer);
            }
        }
        this.shapeLayers = labelLayers;
        return labelLayers;
    }
}

