/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.heatstrip;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatStripLayer
implements PaintedShape {
    private boolean labelLayer = false;
    private String label;
    private double labelWidth = Double.MAX_VALUE;
    private double labelSpacing = 1.0;
    private Color labelColor = Color.BLACK;
    private Color[] colorScale;
    private Font font;
    protected Rectangle2D bounds;
    private double value;
    private double rangeMax;
    private double rangeMin;
    private double maxValue;
    private double minValue;
    private double labelMin;
    private double scale;
    private double bar;
    private double nBars;
    private double separation;
    private boolean showYAxis = false;
    private boolean normalized = false;
    double strokeWidth = 0.5;
    Color strokeColor = Color.BLACK;
    float[] dist3 = new float[]{0.0f, 0.5f, 1.0f};
    float[] dist2 = new float[]{0.0f, 1.0f};
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public HeatStripLayer(int bar, int nbars, int separation, double value, double minValue, double maxValue, boolean normalized, Color[] colorScale, boolean showAxes, double borderWidth, double scale, Color borderColor) {
        this.labelLayer = false;
        this.colorScale = colorScale;
        this.bar = bar;
        this.nBars = nbars;
        this.separation = separation;
        this.value = value;
        this.rangeMax = maxValue;
        this.rangeMin = minValue;
        this.normalized = normalized;
        this.strokeWidth = borderWidth;
        this.strokeColor = borderColor;
        this.scale = scale;
        if (normalized) {
            this.minValue = -1.0;
            this.maxValue = 1.0;
        } else {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }
        this.showYAxis = showAxes;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public HeatStripLayer(int bar, int nbars, int separation, double minValue, double maxValue, boolean normalized, double labelMin, String label, Font font, Color labelColor, double labelWidth, double labelSpacing, boolean showAxes, double scale) {
        this.labelLayer = true;
        this.bar = bar;
        this.nBars = nbars;
        this.separation = separation;
        this.label = label;
        this.labelWidth = labelWidth;
        this.labelSpacing = labelSpacing;
        this.font = font;
        this.labelColor = labelColor;
        this.rangeMax = maxValue;
        this.rangeMin = minValue;
        this.normalized = normalized;
        this.scale = scale;
        if (normalized) {
            this.minValue = -1.0;
            this.maxValue = 1.0;
        } else {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }
        this.showYAxis = showAxes;
        this.labelMin = labelMin;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public Paint getPaint() {
        if (this.labelLayer) {
            return this.labelColor;
        }
        return this.createGradPaint();
    }

    public Paint getPaint(Rectangle2D bounds) {
        if (this.labelLayer) {
            return this.labelColor;
        }
        return this.createGradPaint();
    }

    public Shape getShape() {
        if (this.labelLayer) {
            return this.labelShape();
        }
        return this.barShape();
    }

    public Stroke getStroke() {
        if (!this.labelLayer) {
            return new BasicStroke((float)this.strokeWidth);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return this.strokeColor;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public HeatStripLayer transform(AffineTransform xform) {
        Shape newBounds = xform.createTransformedShape(this.bounds);
        this.bounds = newBounds.getBounds2D();
        return this;
    }

    private Shape barShape() {
        Rectangle2D strip = this.getHeatStrip(this.value);
        if (this.bar == 0.0) {
            Area axes = this.getAxes();
            axes.add(new Area(strip));
            return axes;
        }
        return strip;
    }

    private Shape labelShape() {
        Rectangle2D barShape = this.getHeatStrip(this.labelMin);
        ViewUtils.TextAlignment tAlign = ViewUtils.TextAlignment.ALIGN_LEFT;
        Point2D.Double labelPosition = new Point2D.Double(barShape.getCenterX(), barShape.getMaxY() + (double)(this.font.getSize() / 2));
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.labelWidth, this.labelSpacing);
        double maxHeight = barShape.getWidth();
        textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, maxHeight, 0.0, 70.0);
        if (this.bar == 0.0 && this.showYAxis) {
            double minVal = this.minValue;
            String minLabel = String.valueOf(this.minValue);
            double maxVal = this.maxValue;
            String maxLabel = String.valueOf(this.maxValue);
            if (this.normalized) {
                minVal = this.rangeMin < 0.0 ? -1.0 : 0.0;
                minLabel = String.valueOf(this.rangeMin);
                maxVal = this.rangeMax > 0.0 ? 1.0 : 0.0;
                maxLabel = String.valueOf(this.rangeMax);
            }
            Area a = new Area(this.axisLabelShape(minVal, minLabel));
            a.add(new Area(this.axisLabelShape(maxVal, maxLabel)));
            if (minVal < 0.0 && maxVal > 0.0) {
                a.add(new Area(this.axisLabelShape(0.0, "0.0")));
            }
            if (textShape != null) {
                a.add(new Area(textShape));
            }
            return a;
        }
        return textShape;
    }

    private Rectangle2D getHeatStrip(double val) {
        double h;
        double py1;
        double x = (this.bounds.getX() - this.bounds.getWidth() / 2.0) * this.scale;
        double y = (this.bounds.getY() - this.bounds.getHeight() / 2.0) * this.scale;
        double width = this.bounds.getWidth() * this.scale;
        double height = this.bounds.getHeight() * this.scale;
        double yMid = y + 0.5 * height;
        double sliceSize = (width - this.nBars * this.separation + this.separation) / this.nBars;
        if (sliceSize < 1.0 && this.separation > 0.0) {
            sliceSize = width / this.nBars;
            this.separation = 0.0;
        }
        sliceSize -= this.strokeWidth;
        double min = this.minValue;
        double max = this.maxValue;
        if (Math.abs(max) > Math.abs(min)) {
            min = -1.0 * max;
        } else {
            max = -1.0 * min;
        }
        double px1 = x + this.bar * (sliceSize + this.strokeWidth + this.separation);
        if (val > 0.0) {
            py1 = y + 0.5 * height - 0.5 * height * (val / max) - this.strokeWidth;
            h = 0.5 * height * (val / max) + this.strokeWidth / 4.0;
        } else {
            py1 = y + 0.5 * height - this.strokeWidth / 4.0;
            h = 0.5 * height * (-val / max) - this.strokeWidth;
        }
        return new Rectangle2D.Double(px1, py1, sliceSize, h);
    }

    private Paint createGradPaint() {
        double x = this.bounds.getX() - this.bounds.getWidth() / 2.0;
        double y = this.bounds.getY() - this.bounds.getHeight() / 2.0;
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        if (this.colorScale.length == 2) {
            return new LinearGradientPaint((float)x, (float)(y + height), (float)x, (float)y, this.dist2, this.colorScale);
        }
        return new LinearGradientPaint((float)x, (float)(y + height), (float)x, (float)y, this.dist3, this.colorScale);
    }

    private Area getAxes() {
        Rectangle2D firstBar = this.getHeatStrip(0.0);
        double saveBar = this.bar;
        this.bar = this.nBars - 1.0;
        Rectangle2D lastBar = this.getHeatStrip(0.0);
        this.bar = saveBar;
        Path2D.Double xAxes = new Path2D.Double();
        ((Path2D)xAxes).moveTo(firstBar.getX(), 0.0);
        ((Path2D)xAxes).lineTo(lastBar.getX() + lastBar.getWidth(), 0.0);
        ((Path2D)xAxes).lineTo(lastBar.getX() + lastBar.getWidth(), 0.0);
        ((Path2D)xAxes).lineTo(firstBar.getX(), 0.0);
        xAxes.closePath();
        if (this.showYAxis) {
            Rectangle2D bottom = this.getHeatStrip(this.minValue);
            Rectangle2D top = this.getHeatStrip(this.maxValue);
            ((Path2D)xAxes).moveTo(bottom.getX(), bottom.getMaxY());
            ((Path2D)xAxes).lineTo(top.getX(), top.getMinY());
        }
        return new Area(xAxes);
    }

    private Shape axisLabelShape(double value, String label) {
        Rectangle2D bar = this.getHeatStrip(value);
        ViewUtils.TextAlignment tAlign = ViewUtils.TextAlignment.ALIGN_RIGHT;
        double y = bar.getY();
        if (value < 0.0) {
            y = bar.getMaxY();
        }
        Point2D.Double labelPosition = new Point2D.Double(bar.getMinX() - (double)this.font.getSize(), y);
        Shape textShape = ViewUtils.getLabelShape(label, this.font, this.labelWidth, this.labelSpacing);
        textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, 0.0, 0.0, 0.0);
        return textShape;
    }
}

