/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.heatstrip;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ColorGradients;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.heatstrip.HeatStripLayer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class HeatStripChart
extends AbstractChartCustomGraphics<HeatStripLayer> {
    private static final String COLORS = "colorlist";
    private static final String SEPARATION = "separation";
    private List<Color> colorList = null;
    private String colorString = null;
    private int separation = 0;
    private boolean showAxes = false;
    Color[] colorScale = null;

    public HeatStripChart(String input) {
        Map<String, String> args = this.parseInput(input);
        this.populateValues(args);
        this.colorScale = ColorGradients.YELLOWBLACKCYAN.getColors();
        if (args.containsKey(COLORS)) {
            String colorSpec = args.get(COLORS).toString();
            if (ColorGradients.getGradient(colorSpec) != null) {
                this.colorScale = ColorGradients.getGradient(colorSpec);
            } else {
                try {
                    String[] colorArray = colorSpec.split(",");
                    List<Color> colors = this.parseUpDownColor(colorArray);
                    this.colorScale[1] = colors.get(2);
                    this.colorScale[0] = colors.get(1);
                    this.colorScale[2] = colors.get(0);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("heatstripchart: Unable to parse up/down color: " + colorSpec));
                    this.colorScale = ColorGradients.YELLOWBLACKCYAN.getColors();
                }
            }
        }
        if (args.containsKey(SEPARATION)) {
            this.separation = Integer.parseInt(args.get(SEPARATION));
        }
        if (args.containsKey("showyaxis")) {
            this.showAxes = this.getBooleanValue(args.get("showyaxis"));
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<HeatStripLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        this.layers = new ArrayList();
        CyNode node = (CyNode)nodeView.getModel();
        if (this.attributes != null && this.attributes.size() > 0) {
            this.values = this.getDataFromAttributes(network, node, this.attributes, this.labels);
        }
        if (this.labels != null && this.labels.size() > 0 && this.labels.size() != this.values.size()) {
            this.logger.error((Object)("heatstripchart: number of labels (" + this.labels.size() + "), values (" + this.values.size() + ") don't match"));
            return null;
        }
        ArrayList<HeatStripLayer> labelList = new ArrayList<HeatStripLayer>();
        double minValue = 0.0;
        double maxValue = 0.0;
        for (Double val : this.values) {
            if (val == null) continue;
            minValue = Math.min(minValue, val);
            maxValue = Math.max(maxValue, val);
        }
        double labelMin = minValue;
        if (this.normalized) {
            minValue = this.rangeMin;
            maxValue = this.rangeMax;
        }
        int nBars = this.values.size();
        Font font = this.getFont();
        for (int bar = 0; bar < nBars; ++bar) {
            HeatStripLayer labelLayer;
            HeatStripLayer bl;
            String label = null;
            if (this.labels != null && this.labels.size() > 0) {
                label = (String)this.labels.get(bar);
            }
            if (this.values.get(bar) == null || (bl = new HeatStripLayer(bar, nBars, this.separation, (Double)this.values.get(bar), minValue, maxValue, this.normalized, this.colorScale, this.showAxes, this.borderWidth, this.scale, this.borderColor)) == null) continue;
            this.layers.add(bl);
            if (label == null && (!this.showAxes || bar != 0) || (labelLayer = new HeatStripLayer(bar, nBars, this.separation, minValue, maxValue, this.normalized, labelMin, label, font, this.labelColor, this.labelWidth, this.labelSpacing, this.showAxes, this.scale)) == null) continue;
            labelList.add(labelLayer);
        }
        if (labelList != null && labelList.size() > 0) {
            this.layers.addAll(labelList);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }
}

