/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.circos;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public class CircosLayer
implements PaintedShape {
    private boolean labelLayer = false;
    private double arcStart;
    private double arc;
    private double radiusStart;
    private double circleWidth;
    private double strokeWidth;
    private String label;
    private Color color;
    private Color strokeColor = Color.BLACK;
    private Font font;
    private boolean labelSlice = true;
    private ViewUtils.Position labelOffset = null;
    private double labelWidth = Double.MAX_VALUE;
    private double labelSpacing = 1.0;
    private double maxRadius = 0.0;
    private int circle = 0;
    private int nCircles = 0;
    protected Rectangle2D bounds;
    private boolean isClockwise;

    public CircosLayer(double radiusStart, double circleWidth, double arcStart, double arc, boolean isClockwise, Color color, double strokeWidth, Color strokeColor) {
        this.labelLayer = false;
        this.arcStart = arcStart;
        this.arc = arc;
        this.isClockwise = isClockwise;
        this.color = color;
        this.radiusStart = radiusStart;
        this.circleWidth = circleWidth;
        this.strokeWidth = strokeWidth;
        this.strokeColor = strokeColor;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public CircosLayer(double radiusStart, double circleWidth, double arcStart, double arc, boolean isClockwise, String label, Font font, Color labelColor, double labelWidth, double labelSpacing) {
        this.labelLayer = true;
        this.labelSlice = true;
        this.arcStart = arcStart;
        this.arc = arc;
        this.isClockwise = isClockwise;
        this.label = label;
        this.font = font;
        this.color = labelColor;
        this.labelWidth = labelWidth;
        this.labelSpacing = labelSpacing;
        this.strokeColor = labelColor;
        this.radiusStart = radiusStart;
        this.circleWidth = circleWidth;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public CircosLayer(double radiusStart, double circleWidth, double arcStart, boolean isClockwise, String label, Font font, Color labelColor, double labelWidth, double labelSpacing) {
        this.labelLayer = true;
        this.labelSlice = false;
        this.arcStart = arcStart;
        this.isClockwise = isClockwise;
        this.label = label;
        this.font = font;
        this.color = labelColor;
        this.strokeColor = labelColor;
        this.labelWidth = labelWidth;
        this.labelSpacing = labelSpacing;
        this.radiusStart = radiusStart;
        this.circleWidth = circleWidth;
        this.labelOffset = null;
        this.maxRadius = 0.0;
    }

    public CircosLayer(double radiusStart, double circleWidth, double arcStart, boolean isClockwise, String label, Font font, Color labelColor, double labelWidth, double labelSpacing, ViewUtils.Position labelOffset, double maxRadius, int circle, int nCircles) {
        this.labelLayer = true;
        this.labelSlice = false;
        this.arcStart = arcStart;
        this.isClockwise = isClockwise;
        this.label = label;
        this.font = font;
        this.color = labelColor;
        this.strokeColor = labelColor;
        this.labelWidth = labelWidth;
        this.labelSpacing = labelSpacing;
        this.radiusStart = radiusStart;
        this.circleWidth = circleWidth;
        this.labelOffset = labelOffset;
        this.maxRadius = maxRadius;
        this.circle = circle;
        this.nCircles = nCircles;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public Paint getPaint() {
        return this.color;
    }

    public Paint getPaint(Rectangle2D bounds) {
        return this.color;
    }

    public Shape getShape() {
        if (this.labelLayer && this.labelSlice) {
            return this.labelShape();
        }
        if (this.labelLayer && this.labelOffset != null) {
            return this.labelCircleWithOffset();
        }
        if (this.labelLayer && !this.labelSlice) {
            return this.labelCircle();
        }
        return this.sliceShape();
    }

    public Stroke getStroke() {
        if (!this.labelLayer && this.strokeWidth > 0.0) {
            return new BasicStroke((float)this.strokeWidth);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return this.strokeColor;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public CircosLayer transform(AffineTransform xform) {
        Shape newShape = xform.createTransformedShape(this.bounds);
        Rectangle2D newBounds = newShape.getBounds2D();
        CircosLayer pl = this.labelLayer && this.labelSlice ? new CircosLayer(this.radiusStart, this.circleWidth, this.arcStart, this.arc, this.isClockwise, this.label, this.font, this.color, this.labelWidth, this.labelSpacing) : (this.labelLayer && !this.labelSlice ? new CircosLayer(this.radiusStart, this.circleWidth, this.arcStart, this.isClockwise, this.label, this.font, this.color, this.labelWidth, this.labelSpacing, this.labelOffset, this.maxRadius, this.circle, this.nCircles) : new CircosLayer(this.radiusStart, this.circleWidth, this.arcStart, this.arc, this.isClockwise, this.color, this.strokeWidth, this.strokeColor));
        pl.bounds = newBounds;
        return pl;
    }

    private Shape sliceShape() {
        double x = this.bounds.getX() - this.bounds.getWidth() * this.radiusStart / 2.0;
        double y = this.bounds.getY() - this.bounds.getHeight() * this.radiusStart / 2.0;
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        double radiusEnd = this.radiusStart + this.circleWidth;
        Path2D.Double path = new Path2D.Double();
        Arc2D.Double innerSlice = this.isClockwise ? new Arc2D.Double(x, y, width * this.radiusStart, height * this.radiusStart, this.arcStart, -this.arc, 0) : new Arc2D.Double(x, y, width * this.radiusStart, height * this.radiusStart, this.arcStart + this.arc, -this.arc, 0);
        Point2D innerStart = innerSlice.getStartPoint();
        Point2D innerEnd = innerSlice.getEndPoint();
        x = this.bounds.getX() - this.bounds.getWidth() * radiusEnd / 2.0;
        y = this.bounds.getY() - this.bounds.getHeight() * radiusEnd / 2.0;
        Arc2D.Double outerSlice = this.isClockwise ? new Arc2D.Double(x, y, width * radiusEnd, height * radiusEnd, this.arcStart - this.arc, this.arc, 0) : new Arc2D.Double(x, y, width * radiusEnd, height * radiusEnd, this.arcStart, this.arc, 0);
        Point2D outerStart = outerSlice.getStartPoint();
        Point2D outerEnd = outerSlice.getEndPoint();
        ((Path2D)path).moveTo(innerStart.getX(), innerStart.getY());
        this.appendArc(path, innerSlice);
        ((Path2D)path).lineTo(outerStart.getX(), outerStart.getY());
        this.appendArc(path, outerSlice);
        ((Path2D)path).lineTo(innerStart.getX(), innerStart.getY());
        path.closePath();
        return path;
    }

    private Shape labelCircleWithOffset() {
        double offset = this.nCircles / 2 - this.circle;
        double lineHeight = ViewUtils.getLabelShape("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz-_,:|\"", this.font, Double.MAX_VALUE, 1.0).getBounds().getHeight();
        double yLabel = offset * lineHeight * (1.0 + this.labelSpacing);
        double x = this.bounds.getX();
        ViewUtils.TextAlignment tAlign = ViewUtils.TextAlignment.ALIGN_CENTER;
        if (this.labelOffset == ViewUtils.Position.WEST) {
            x -= (this.maxRadius + this.circleWidth) * this.bounds.getWidth() / 2.0;
            tAlign = ViewUtils.TextAlignment.ALIGN_RIGHT;
        } else if (this.labelOffset == ViewUtils.Position.EAST) {
            x += (this.maxRadius + this.circleWidth) * this.bounds.getWidth() / 2.0;
            tAlign = ViewUtils.TextAlignment.ALIGN_LEFT;
        }
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.labelWidth, this.labelSpacing);
        Point2D.Double labelPosition = new Point2D.Double(x, yLabel);
        textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, 0.0, 0.0, 0.0);
        Point2D labelLineStart = ViewUtils.getLabelLineStart(textShape.getBounds2D(), tAlign);
        double a = (this.radiusStart - this.circleWidth / 2.0) * this.bounds.getWidth() / 2.0;
        double b = (this.radiusStart - this.circleWidth / 2.0) * this.bounds.getHeight() / 2.0;
        double x0 = labelLineStart.getX();
        double y0 = labelLineStart.getY();
        double discriminant = a * b / Math.sqrt(Math.pow(a, 2.0) * Math.pow(y0, 2.0) + Math.pow(b, 2.0) * Math.pow(x0, 2.0));
        Point2D.Double lineEnd = new Point2D.Double(x0 * discriminant, y0 * discriminant);
        Shape labelLine = ViewUtils.getLabelLine(textShape.getBounds2D(), lineEnd, tAlign);
        Area textArea = new Area(textShape);
        textArea.add(new Area(labelLine));
        return textArea;
    }

    private Shape labelCircle() {
        double midpointAngle = 90.0;
        double width = this.bounds.getWidth();
        double height = this.circleWidth * this.bounds.getHeight();
        double x = this.bounds.getX();
        double y = this.bounds.getY() - this.bounds.getHeight() * this.radiusStart / 2.0;
        Rectangle2D.Double labelBounds = new Rectangle2D.Double(x, y, width, height);
        ViewUtils.TextAlignment tAlign = ViewUtils.TextAlignment.ALIGN_CENTER;
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.labelWidth, this.labelSpacing);
        Point2D.Double labelPosition = new Point2D.Double(x, y);
        textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, 0.0, 0.0, 0.0);
        return textShape;
    }

    private Shape labelShape() {
        double midpointAngle = this.arcStart + this.arc / 2.0;
        if (this.isClockwise) {
            midpointAngle = this.arcStart - this.arc / 2.0;
        }
        double width = this.bounds.getWidth() * (this.radiusStart + this.circleWidth / 2.0);
        double height = this.bounds.getHeight() * (this.radiusStart + this.circleWidth / 2.0);
        double x = this.bounds.getX();
        double y = this.bounds.getY();
        Rectangle2D.Double labelBounds = new Rectangle2D.Double(x, y, width, height);
        ViewUtils.TextAlignment tAlign = this.getLabelAlignment(midpointAngle);
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.labelWidth, this.labelSpacing);
        Point2D labelPosition = this.getLabelPosition(labelBounds, midpointAngle, 1.0 + this.circleWidth);
        if ((textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, 0.0, 0.0, 0.0)) == null) {
            return null;
        }
        labelPosition = this.getLabelPosition(labelBounds, midpointAngle, 1.0);
        Shape labelLine = ViewUtils.getLabelLine(textShape.getBounds2D(), labelPosition, tAlign);
        Area textArea = new Area(textShape);
        textArea.add(new Area(labelLine));
        return textArea;
    }

    private Point2D getLabelPosition(Rectangle2D bbox, double angle, double scale) {
        double midpoint = Math.toRadians(angle);
        double w = bbox.getWidth() / 2.0 * scale;
        double h = bbox.getHeight() / 2.0 * scale;
        double x = Math.cos(midpoint) * w + bbox.getX();
        double y = -Math.sin(midpoint) * h + bbox.getY();
        return new Point2D.Double(x, y);
    }

    private ViewUtils.TextAlignment getLabelAlignment(double midPointAngle) {
        while (midPointAngle < 0.0) {
            midPointAngle += 360.0;
        }
        while (midPointAngle >= 360.0) {
            midPointAngle -= 360.0;
        }
        if (midPointAngle >= 280.0 || midPointAngle < 80.0) {
            return ViewUtils.TextAlignment.ALIGN_LEFT;
        }
        if (midPointAngle >= 80.0 && midPointAngle < 100.0) {
            return ViewUtils.TextAlignment.ALIGN_CENTER_BOTTOM;
        }
        if (midPointAngle >= 100.0 && midPointAngle < 260.0) {
            return ViewUtils.TextAlignment.ALIGN_RIGHT;
        }
        if (midPointAngle >= 260.0 && midPointAngle < 280.0) {
            return ViewUtils.TextAlignment.ALIGN_CENTER_TOP;
        }
        return ViewUtils.TextAlignment.ALIGN_LEFT;
    }

    private void sortSlicesBySize(List<Double> values, List<Color> colors, List<String> labels, double minimumSlice) {
        Double[] valueArray = values.toArray(new Double[1]);
        values.clear();
        Color[] colorArray = colors.toArray(new Color[1]);
        colors.clear();
        String[] labelArray = labels.toArray(new String[1]);
        labels.clear();
        Integer[] sortedIndex = new Integer[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            sortedIndex[i] = new Integer(i);
        }
        IndexComparator iCompare = new IndexComparator(valueArray);
        Arrays.sort(sortedIndex, iCompare);
        double otherValues = 0.0;
        for (int index = valueArray.length - 1; index >= 0; --index) {
            if (valueArray[sortedIndex[index]] >= minimumSlice) {
                values.add(valueArray[sortedIndex[index]]);
                colors.add(colorArray[sortedIndex[index]]);
                labels.add(labelArray[sortedIndex[index]]);
                continue;
            }
            otherValues += valueArray[sortedIndex[index]].doubleValue();
        }
        if (otherValues > 0.0) {
            values.add(otherValues);
            colors.add(Color.LIGHT_GRAY);
            labels.add("Other");
        }
    }

    private void appendArc(Path2D path, Arc2D arc) {
        PathIterator pi = arc.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coords = new double[6];
            int pathType = pi.currentSegment(coords);
            switch (pathType) {
                case 0: 
                case 4: {
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                }
            }
            pi.next();
        }
    }

    private class IndexComparator
    implements Comparator<Integer> {
        Double[] data = null;
        Integer[] intData = null;

        public IndexComparator(Double[] data) {
            this.data = data;
        }

        public IndexComparator(Integer[] data) {
            this.intData = data;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.data != null) {
                if (this.data[o1] < this.data[o2]) {
                    return -1;
                }
                if (this.data[o1] > this.data[o2]) {
                    return 1;
                }
                return 0;
            }
            if (this.intData != null) {
                if (this.intData[o1] < this.intData[o2]) {
                    return -1;
                }
                if (this.intData[o1] > this.intData[o2]) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

