/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.circos;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.circos.CircosLayer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class CircosChart
extends AbstractChartCustomGraphics<CircosLayer> {
    private static final String COLORS = "colorlist";
    private static final String LABELCIRCLES = "labelcircles";
    private static final String CIRCLELABELS = "circlelabels";
    private static final String SORTSLICES = "sortslices";
    private static final String MINIMUMSLICE = "minimumslice";
    private static final String ARCSTART = "arcstart";
    private static final String ARCDIRECTION = "arcdirection";
    private static final String FIRSTARC = "firstarc";
    private static final String FIRSTARCWIDTH = "firstarcwidth";
    private static final String ARCWIDTH = "arcwidth";
    private static final String STROKEWIDTH = "outlineWidth";
    private static final String STROKECOLOR = "outlineColor";
    private List<List<Double>> valueList = null;
    private List<Color> colors = null;
    private List<String> circleLabels = null;
    private boolean labelCircles = false;
    private ViewUtils.Position labelOffset = null;
    private double arcStart = 0.0;
    private boolean isClockwise = false;
    private boolean sortSlices = true;
    private double minimumSlice = 2.0;
    private double firstArc = 0.2;
    private double arcWidth = 0.1;
    private double firstArcWidth = 0.1;
    private double outlineWidth = 0.1;
    private String colorString = null;

    public CircosChart(String input) {
        Map<String, String> args = this.parseInput(input);
        String strValues = null;
        if (args.containsKey("valuelist")) {
            strValues = args.get("valuelist");
            args.remove("valuelist");
        }
        this.populateValues(args);
        if (!args.containsKey("labellist")) {
            this.labels = null;
        }
        if (strValues != null && strValues.startsWith("[") && strValues.endsWith("]")) {
            this.valueList = new ArrayList<List<Double>>();
            strValues = strValues.substring(1, strValues.length() - 1);
            for (String s : strValues.split("\\],\\[")) {
                this.values = this.convertInputToDouble(s);
                if (this.values == null) {
                    this.logger.error((Object)("Cannot parse valuelist from input '" + s + "' of the input list '" + strValues + "'"));
                    return;
                }
                if (this.rangeMax != 0.0 || this.rangeMin != 0.0) {
                    this.values = this.normalize(this.values, this.rangeMin, this.rangeMax);
                    this.normalized = true;
                }
                this.valueList.add(this.convertData(this.values));
            }
        } else {
            this.values = null;
            if (strValues != null) {
                this.values = this.convertInputToDouble(strValues);
                if (this.values == null) {
                    this.logger.error((Object)("Cannot parse valuelist from input '" + strValues + "'"));
                    return;
                }
                if (this.rangeMax != 0.0 || this.rangeMin != 0.0) {
                    this.values = this.normalize(this.values, this.rangeMin, this.rangeMax);
                    this.normalized = true;
                }
            }
        }
        if (args.containsKey(COLORS)) {
            this.colorString = args.get(COLORS);
        }
        if (args.containsKey(SORTSLICES)) {
            this.sortSlices = this.getBooleanValue(args.get(SORTSLICES));
        }
        if (args.containsKey(ARCSTART)) {
            this.arcStart = this.getDoubleValue(args.get(ARCSTART));
        }
        if (args.containsKey(ARCDIRECTION)) {
            String direction = args.get(ARCDIRECTION).trim().toLowerCase();
            boolean bl = this.isClockwise = direction.equals("clockwise") || direction.equals("cw") || direction.equals("clock");
        }
        if (args.containsKey(FIRSTARC)) {
            this.firstArc = this.getDoubleValue(args.get(FIRSTARC));
        }
        if (args.containsKey(ARCWIDTH)) {
            this.arcWidth = this.getDoubleValue(args.get(ARCWIDTH));
        }
        this.firstArcWidth = args.containsKey(FIRSTARCWIDTH) ? this.getDoubleValue(args.get(FIRSTARCWIDTH)) : this.arcWidth;
        if (args.containsKey(LABELCIRCLES)) {
            this.labelOffset = ViewUtils.Position.getPosition(args.get(LABELCIRCLES));
            this.labelCircles = this.labelOffset != null ? true : this.getBooleanValue(args.get(LABELCIRCLES));
        }
        if (args.containsKey(CIRCLELABELS)) {
            this.circleLabels = this.getStringList(args.get(CIRCLELABELS));
        }
        if (args.containsKey(STROKEWIDTH)) {
            this.outlineWidth = this.getDoubleValue(args.get(STROKEWIDTH));
        } else if (args.containsKey("borderwidth")) {
            this.outlineWidth = this.getDoubleValue(args.get("borderwidth"));
        }
        if (args.containsKey(STROKECOLOR)) {
            this.borderColor = this.getColorValue(args.get(STROKECOLOR));
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    private List<Color> convertInputToColor(String colorString, List<Double> values, int index) {
        if (colorString == null || !colorString.startsWith("[") || !colorString.endsWith("]")) {
            return this.convertInputToColor(colorString, values);
        }
        String[] colorsplit = (colorString = colorString.substring(1, colorString.length() - 1)).split("\\],\\[");
        if (index >= colorsplit.length) {
            return this.convertInputToColor(colorString, values);
        }
        String strcolor = colorsplit[index];
        return this.convertInputToColor(strcolor, values);
    }

    @Override
    public List<CircosLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        int circle;
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        this.layers = new ArrayList();
        CyNode node = (CyNode)nodeView.getModel();
        ArrayList<List<Color>> colorList = null;
        List<String> cLabels = this.circleLabels;
        int nCircles = 0;
        Font font = this.getFont();
        if (this.attributes != null && this.attributes.size() > 0) {
            int index;
            if (this.values == null || this.values.size() == 0) {
                this.valueList = new ArrayList<List<Double>>();
                colorList = new ArrayList();
                index = 0;
                for (String attr : this.attributes) {
                    this.values = this.getDataFromAttributes(network, node, Collections.singletonList(attr), this.labels);
                    this.values = this.convertData(this.values);
                    this.valueList.add(this.values);
                    colorList.add(this.convertInputToColor(this.colorString, this.values, index++));
                }
                nCircles = this.valueList.size();
            } else {
                colorList = new ArrayList();
                index = 0;
                for (String attr : this.attributes) {
                    List<Double> attrValues = this.getDataFromAttributes(network, node, Collections.singletonList(attr), this.labels);
                    this.colors = this.convertInputToColor(this.colorString, attrValues, index++);
                    if (this.colors == null) {
                        return null;
                    }
                    colorList.add(this.colors);
                }
                this.values = this.convertData(this.values);
                nCircles = colorList.size();
            }
        } else if (this.valueList != null) {
            colorList = new ArrayList<List<Color>>();
            for (int i = 0; i < this.valueList.size(); ++i) {
                this.values = this.convertData(this.valueList.get(i));
                this.valueList.set(i, this.values);
                this.colors = this.convertInputToColor(this.colorString, this.values, i);
                if (this.colors == null) {
                    return null;
                }
                colorList.add(this.colors);
            }
            nCircles = this.valueList.size();
        } else if (this.values != null) {
            nCircles = 1;
            this.values = this.convertData(this.values);
            this.colors = this.convertInputToColor(this.colorString, this.values, 0);
        }
        if (cLabels != null && (cLabels.size() != nCircles || cLabels.size() == 1 && nCircles == 1)) {
            CyColumn column;
            if (cLabels.size() == 1 && (column = network.getDefaultNodeTable().getColumn(cLabels.get(0))) != null) {
                if (column.getType().equals(List.class) && column.getListElementType().equals(String.class)) {
                    cLabels = new ArrayList<String>(network.getRow((CyIdentifiable)node).getList(cLabels.get(0), String.class));
                } else if (column.getType().equals(String.class)) {
                    cLabels = this.getStringList((String)network.getRow((CyIdentifiable)node).get(cLabels.get(0), String.class));
                }
            }
            if (cLabels.size() != nCircles) {
                this.logger.error((Object)("circoschart: number of circle labels (" + this.circleLabels.size() + "), doesn't match the number of circles (" + nCircles + ")"));
                return null;
            }
        }
        if (this.labels != null && this.labels.size() > 0 && (this.values != null && this.labels.size() != this.values.size() || this.colors != null && this.labels.size() != this.colors.size())) {
            this.logger.error((Object)("circoschart: number of labels (" + this.labels.size() + "), values (" + (this.values != null ? Integer.valueOf(this.values.size()) : "null") + "), and colors (" + (this.colors != null ? Integer.valueOf(this.colors.size()) : "null") + ") don't match"));
            return null;
        }
        ArrayList<CircosLayer> labelList = new ArrayList<CircosLayer>();
        double rad = this.firstArc;
        double maxRadius = this.firstArc + this.firstArcWidth + this.arcWidth * (double)(nCircles - 1);
        for (circle = 0; circle < nCircles; ++circle) {
            if (this.valueList != null) {
                this.values = this.valueList.get(circle);
            }
            if (colorList != null) {
                this.colors = (List)colorList.get(circle);
            }
            int nSlices = this.values.size();
            double arc = this.arcStart;
            double circleWidth = this.arcWidth;
            if (circle == 0) {
                circleWidth = this.firstArcWidth;
            }
            for (int slice = 0; slice < nSlices; ++slice) {
                CircosLayer labelLayer;
                String label = null;
                if (this.labels != null && this.labels.size() > 0) {
                    label = (String)this.labels.get(slice);
                }
                if ((Double)this.values.get(slice) <= 0.0) {
                    this.logger.warn((Object)("The slice " + slice + " of circle " + circle + " has a negative value: " + this.values.get(slice) + ". This slice is ignored."));
                    continue;
                }
                CircosLayer pl = new CircosLayer(rad, circleWidth, arc, (Double)this.values.get(slice), this.isClockwise, this.colors.get(slice), this.outlineWidth, this.borderColor);
                if (pl == null) continue;
                this.layers.add(pl);
                if (label != null && circle == nCircles - 1 && (labelLayer = new CircosLayer(rad, circleWidth, arc, (Double)this.values.get(slice), this.isClockwise, label, font, this.labelColor, this.labelWidth, this.labelSpacing)) != null) {
                    labelList.add(labelLayer);
                }
                if (this.isClockwise) {
                    arc -= ((Double)this.values.get(slice)).doubleValue();
                    continue;
                }
                arc += ((Double)this.values.get(slice)).doubleValue();
            }
            rad += circleWidth;
        }
        rad = maxRadius;
        for (circle = nCircles - 1; circle >= 0; --circle) {
            CircosLayer labelLayer;
            String circleLabel = "";
            if (this.attributes != null && circle < this.attributes.size()) {
                circleLabel = (String)this.attributes.get(circle);
            }
            if (cLabels != null) {
                circleLabel = cLabels.get(circle);
            }
            double circleWidth = this.arcWidth;
            if (circle == 0) {
                circleWidth = this.firstArcWidth;
            }
            if (this.labelCircles && this.labelOffset != null && (labelLayer = new CircosLayer(rad, circleWidth, this.arcStart, this.isClockwise, circleLabel, font, this.labelColor, this.labelWidth, this.labelSpacing, this.labelOffset, maxRadius, circle, nCircles)) != null) {
                labelList.add(labelLayer);
            }
            rad -= circleWidth;
        }
        if (labelList != null && labelList.size() > 0) {
            this.layers.addAll(labelList);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }

    private List<Double> convertData(List<Double> values) {
        double totalSize = 0.0;
        int nValues = values.size();
        for (Double d : values) {
            if (!(d >= 0.0)) continue;
            totalSize += d.doubleValue();
        }
        for (int index = 0; index < nValues; ++index) {
            double v = values.get(index);
            values.set(index, v * 360.0 / totalSize);
        }
        return values;
    }
}

