/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.bar;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.bar.BarLayer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class BarChart
extends AbstractChartCustomGraphics<BarLayer> {
    private static final String COLORS = "colorlist";
    private static final String SEPARATION = "separation";
    private List<Color> colorList = null;
    private String colorString = null;
    private int separation = 0;
    private boolean showAxes = false;

    public BarChart(String input) {
        Map<String, String> args = this.parseInput(input);
        this.populateValues(args);
        if (args.containsKey(COLORS)) {
            this.colorString = args.get(COLORS);
        }
        if (args.containsKey(SEPARATION)) {
            try {
                this.separation = Integer.parseInt(args.get(SEPARATION));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn((Object)"Value for separation is not an integer");
            }
        }
        if (args.containsKey("showyaxis")) {
            this.showAxes = this.getBooleanValue(args.get("showyaxis"));
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<BarLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        this.layers = new ArrayList();
        CyNode node = (CyNode)nodeView.getModel();
        if (this.attributes != null && this.attributes.size() > 0) {
            this.values = this.getDataFromAttributes(network, node, this.attributes, this.labels);
        }
        this.colorList = this.convertInputToColor(this.colorString, this.values);
        if (this.labels != null && this.labels.size() > 0 && (this.labels.size() != this.values.size() || this.labels.size() != this.colorList.size())) {
            this.logger.error((Object)("barchart: number of labels (" + this.labels.size() + "), values (" + this.values.size() + "), and colors (" + this.colorList.size() + ") don't match"));
            return null;
        }
        ArrayList<BarLayer> labelList = new ArrayList<BarLayer>();
        double minValue = 0.0;
        double maxValue = 0.0;
        for (Double val : this.values) {
            if (val == null) continue;
            minValue = Math.min(minValue, val);
            maxValue = Math.max(maxValue, val);
        }
        double labelMin = minValue;
        int nBars = this.values.size();
        Font font = this.getFont();
        for (int bar = 0; bar < nBars; ++bar) {
            BarLayer labelLayer;
            BarLayer bl;
            String label = null;
            if (this.labels != null && this.labels.size() > 0) {
                label = (String)this.labels.get(bar);
            }
            if (this.values.get(bar) == null || (bl = new BarLayer(bar, nBars, this.separation, (Double)this.values.get(bar), minValue, maxValue, this.rangeMin, this.rangeMax, this.normalized, this.ybase, this.colorList.get(bar), this.showAxes, this.borderWidth, this.scale, this.borderColor)) == null) continue;
            this.layers.add(bl);
            if (label == null && (!this.showAxes || bar != 0) || (labelLayer = new BarLayer(bar, nBars, this.separation, minValue, maxValue, this.rangeMin, this.rangeMax, this.normalized, labelMin, this.ybase, label, font, this.labelColor, this.labelWidth, this.labelSpacing, this.showAxes, this.scale)) == null) continue;
            labelList.add(labelLayer);
        }
        if (labelList != null && labelList.size() > 0) {
            this.layers.addAll(labelList);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }
}

