/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;

public class ViewUtils {
    public static final String DEFAULT_FONT = "SansSerif";
    public static final int DEFAULT_STYLE = 0;
    public static final int DEFAULT_SIZE = 8;
    public static final double DEFAULT_LABEL_WIDTH = Double.MAX_VALUE;
    public static final double DEFAULT_LABEL_LINE_SPACING = 1.0;
    public static final HashMap<String, TextAlignment> textAlignmentMapping = new HashMap(8);

    public static Object getPosition(String position) {
        Position pos = Position.getPosition(position);
        if (pos != null) {
            return pos;
        }
        String[] xy = position.split(",");
        if (xy.length != 2) {
            return null;
        }
        try {
            Double x = Double.valueOf(xy[0]);
            Double y = Double.valueOf(xy[1]);
            return new Point2D.Double(x, y);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Shape getLabelShape(String label, Font font, double maxWidth, double lineSpacing) {
        int labelLength;
        if (label == null) {
            return null;
        }
        FontRenderContext frc = new FontRenderContext(null, false, false);
        char[] labelChars = label.toCharArray();
        int firstCharNextLine = 0;
        int lastCharNextLine = labelLength = label.length();
        Area labelShape = new Area();
        while (firstCharNextLine < labelLength) {
            String labelLine = new String(labelChars, firstCharNextLine, lastCharNextLine - firstCharNextLine);
            TextLayout lineTL = new TextLayout(labelLine, font, frc);
            if (labelLine.length() == 1 || lineTL.getBounds().getWidth() <= maxWidth) {
                double marginTop = labelShape.isEmpty() ? 0.0 : lineSpacing;
                Shape lineShape = lineTL.getOutline(AffineTransform.getTranslateInstance(0.0, labelShape.getBounds().getHeight() + marginTop));
                labelShape.add(new Area(lineShape));
                firstCharNextLine = lastCharNextLine;
                lastCharNextLine = labelLength;
                continue;
            }
            --lastCharNextLine;
        }
        return labelShape;
    }

    public static Shape getLabelShape(String label, String fontName, int fontStyle, int fontSize, double maxWidth, double lineSpacing) {
        if (fontName == null) {
            fontName = DEFAULT_FONT;
        }
        if (fontStyle == 0) {
            fontStyle = 0;
        }
        if (fontSize == 0) {
            fontSize = 8;
        }
        Font font = new Font(fontName, fontStyle, fontSize);
        return ViewUtils.getLabelShape(label, font, maxWidth, lineSpacing);
    }

    public static Shape positionLabel(Shape lShape, Point2D position, TextAlignment tAlign, double maxHeight, double maxWidth, double rotation) {
        if (lShape == null) {
            return null;
        }
        AffineTransform initTrans = new AffineTransform();
        initTrans.translate(-lShape.getBounds2D().getX(), -lShape.getBounds2D().getY());
        lShape = initTrans.createTransformedShape(lShape);
        double textWidth = lShape.getBounds2D().getWidth();
        double textHeight = lShape.getBounds2D().getHeight();
        if (maxHeight > 0.0 || maxWidth > 0.0) {
            double scale;
            double scaleWidth = 1.0;
            double scaleHeight = 1.0;
            if (maxWidth > 0.0 && textWidth > maxWidth) {
                scaleWidth = maxWidth / textWidth * 0.9;
            }
            if (maxHeight > 0.0 && textHeight > maxHeight) {
                scaleHeight = maxHeight / textHeight * 0.9;
            }
            if ((scale = Math.min(scaleWidth, scaleHeight)) < 0.2) {
                return null;
            }
            if (scale != 1.0) {
                AffineTransform sTransform = new AffineTransform();
                sTransform.scale(scale, scale);
                lShape = sTransform.createTransformedShape(lShape);
            }
        }
        double pointX = position.getX();
        double pointY = position.getY();
        double textStartX = pointX;
        double textStartY = pointY;
        switch (tAlign) {
            case ALIGN_CENTER_TOP: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY + textHeight / 2.0;
                break;
            }
            case ALIGN_CENTER_BOTTOM: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY - textHeight;
                break;
            }
            case ALIGN_RIGHT: {
                textStartX = pointX - textWidth;
                textStartY = pointY - textHeight / 2.0;
                break;
            }
            case ALIGN_LEFT: {
                textStartX = pointX;
                textStartY = pointY - textHeight / 2.0;
                break;
            }
            case ALIGN_MIDDLE: {
                textStartX = pointX - textWidth / 2.0;
                textStartY = pointY - textHeight / 2.0;
                break;
            }
            case ALIGN_CENTER: {
                textStartX = pointX - textWidth / 2.0;
                break;
            }
        }
        AffineTransform trans = new AffineTransform();
        if (rotation != 0.0) {
            trans.rotate(Math.toRadians(rotation), pointX, pointY);
        }
        trans.translate(textStartX, textStartY);
        return trans.createTransformedShape(lShape);
    }

    public static Shape getLabelLine(Rectangle2D textBounds, Point2D labelPosition, TextAlignment tAlign) {
        Point2D start = ViewUtils.getLabelLineStart(textBounds, tAlign);
        BasicStroke stroke = new BasicStroke(0.5f);
        return stroke.createStrokedShape(new Line2D.Double(start.getX(), start.getY(), labelPosition.getX(), labelPosition.getY()));
    }

    public static Point2D getLabelLineStart(Rectangle2D textBounds, TextAlignment tAlign) {
        double lineStartX = 0.0;
        double lineStartY = 0.0;
        switch (tAlign) {
            case ALIGN_CENTER_TOP: {
                lineStartY = textBounds.getMinY() - 1.0;
                lineStartX = textBounds.getCenterX();
                break;
            }
            case ALIGN_CENTER_BOTTOM: {
                lineStartY = textBounds.getMaxY() + 1.0;
                lineStartX = textBounds.getCenterX();
                break;
            }
            case ALIGN_RIGHT: {
                lineStartY = textBounds.getCenterY();
                lineStartX = textBounds.getMaxX() + 1.0;
                break;
            }
            case ALIGN_LEFT: {
                lineStartY = textBounds.getCenterY();
                lineStartX = textBounds.getMinX() - 1.0;
            }
        }
        return new Point2D.Double(lineStartX, lineStartY);
    }

    public static Point2D positionAdjust(Rectangle2D bbox, Rectangle2D textBox, Object pos, Object anchor) {
        if (pos == null) {
            return null;
        }
        Point2D anchorOffset = new Point2D.Double(0.0, 0.0);
        if (anchor != null) {
            anchorOffset = ViewUtils.anchorOffset(textBox, anchor);
        }
        double x = bbox.getX();
        double y = bbox.getY();
        double nodeWidth = bbox.getWidth();
        double nodeHeight = bbox.getHeight();
        if (pos instanceof Position) {
            Position p = (Position)((Object)pos);
            switch (p) {
                case EAST: {
                    x = nodeWidth / 2.0;
                    break;
                }
                case WEST: {
                    x = -nodeWidth / 2.0;
                    break;
                }
                case NORTH: {
                    y = -nodeHeight / 2.0;
                    break;
                }
                case SOUTH: {
                    y = nodeHeight / 2.0;
                    break;
                }
                case NORTHEAST: {
                    x = nodeWidth / 2.0;
                    y = -nodeHeight / 2.0;
                    break;
                }
                case NORTHWEST: {
                    x = -nodeWidth / 2.0;
                    y = -nodeHeight / 2.0;
                    break;
                }
                case SOUTHEAST: {
                    x = nodeWidth / 2.0;
                    y = nodeHeight / 2.0;
                    break;
                }
                case SOUTHWEST: {
                    x = -nodeWidth / 2.0;
                    y = nodeHeight / 2.0;
                    break;
                }
            }
        } else if (pos instanceof Point2D.Double) {
            x += ((Point2D.Double)pos).getX();
            y += ((Point2D.Double)pos).getY();
        }
        return new Point2D.Double(x + anchorOffset.getX(), y + anchorOffset.getY());
    }

    public static Point2D anchorOffset(Rectangle2D textBox, Object anchor) {
        double x = textBox.getX();
        double y = textBox.getY();
        double textWidth = textBox.getWidth();
        double textHeight = textBox.getHeight();
        if (anchor instanceof Position) {
            Position p = (Position)((Object)anchor);
            switch (p) {
                case EAST: {
                    x -= textWidth / 2.0;
                    break;
                }
                case WEST: {
                    x += textWidth / 2.0;
                    break;
                }
                case NORTH: {
                    y += textHeight / 2.0;
                    break;
                }
                case SOUTH: {
                    y -= textHeight / 2.0;
                    break;
                }
                case NORTHEAST: {
                    x -= textWidth / 2.0;
                    y += textHeight / 2.0;
                    break;
                }
                case NORTHWEST: {
                    x += textWidth / 2.0;
                    y += textHeight / 2.0;
                    break;
                }
                case SOUTHEAST: {
                    x -= textWidth / 2.0;
                    y -= textHeight / 2.0;
                    break;
                }
                case SOUTHWEST: {
                    x += textWidth / 2.0;
                    y -= textHeight / 2.0;
                    break;
                }
            }
        } else if (anchor instanceof Point2D.Double) {
            x += ((Point2D.Double)anchor).getX();
            y += ((Point2D.Double)anchor).getY();
        }
        return new Point2D.Double(x, y);
    }

    public static Shape copyShape(Shape shape) {
        AffineTransform identity = new AffineTransform();
        return identity.createTransformedShape(shape);
    }

    public static BufferedImage getShadow(Shape shape, int size) {
        Rectangle2D shapeBounds = shape.getBounds2D();
        BufferedImage image = new BufferedImage((int)shapeBounds.getWidth(), (int)shapeBounds.getHeight(), 2);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(1 + (int)(shapeBounds.getWidth() / 2.0), 1 + (int)(shapeBounds.getHeight() / 2.0));
        g2d.setColor(Color.BLACK);
        g2d.fill(shape);
        g2d.dispose();
        return image;
    }

    public static BufferedImage createDropShadow(BufferedImage image, int size) {
        BufferedImage shadow = new BufferedImage(image.getWidth() + 4 * size, image.getHeight() + 4 * size, 2);
        Graphics2D g2 = shadow.createGraphics();
        g2.drawImage((Image)image, size * 2, size * 2, null);
        g2.setComposite(AlphaComposite.SrcIn);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, shadow.getWidth(), shadow.getHeight());
        g2.dispose();
        shadow = ViewUtils.getGaussianBlurFilter(size, true).filter(shadow, null);
        shadow = ViewUtils.getGaussianBlurFilter(size, false).filter(shadow, null);
        return shadow;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public static Shape createPossiblyTransformedShape(AffineTransform xform, Shape shape, boolean rescale) {
        double[] matrix = new double[6];
        xform.getMatrix(matrix);
        if (rescale) {
            double scale = matrix[0];
            if (matrix[0] != matrix[3]) {
                scale = Math.min(matrix[0], matrix[3]);
            }
            matrix[0] = scale;
            matrix[3] = scale;
        } else {
            matrix[0] = 1.0;
            matrix[3] = 1.0;
        }
        AffineTransform newXform = new AffineTransform(matrix);
        return newXform.createTransformedShape(shape);
    }

    static {
        textAlignmentMapping.put("none", TextAlignment.ALIGN_NONE);
        textAlignmentMapping.put("left", TextAlignment.ALIGN_LEFT);
        textAlignmentMapping.put("center", TextAlignment.ALIGN_CENTER);
        textAlignmentMapping.put("center_top", TextAlignment.ALIGN_CENTER_TOP);
        textAlignmentMapping.put("right", TextAlignment.ALIGN_RIGHT);
        textAlignmentMapping.put("center_bottom", TextAlignment.ALIGN_CENTER_BOTTOM);
        textAlignmentMapping.put("middle", TextAlignment.ALIGN_MIDDLE);
    }

    public static enum Position {
        CENTER("center"),
        EAST("east"),
        NORTH("north"),
        NORTHEAST("northeast"),
        NORTHWEST("northwest"),
        SOUTH("south"),
        SOUTHEAST("southeast"),
        SOUTHWEST("southwest"),
        WEST("west");

        private String label;
        private static Map<String, Position> pMap;

        private Position(String label) {
            this.label = label;
            this.addPosition(this);
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        private void addPosition(Position pos) {
            if (pMap == null) {
                pMap = new HashMap<String, Position>();
            }
            pMap.put(pos.getLabel(), pos);
        }

        public static Position getPosition(String label) {
            if (pMap.containsKey(label)) {
                return pMap.get(label);
            }
            return null;
        }
    }

    public static enum TextAlignment {
        ALIGN_NONE,
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_CENTER_TOP,
        ALIGN_RIGHT,
        ALIGN_CENTER_BOTTOM,
        ALIGN_MIDDLE;

    }
}

