/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;

public class ShadowLayer
implements Cy2DGraphicLayer {
    protected Rectangle2D bounds;
    protected Shape pShape;
    protected boolean rescale;
    protected double radius = 10.0;
    protected double upscale = 10.0;
    protected static int fileNumber = 0;

    public ShadowLayer(Shape shape, double offset, boolean rescale) {
        this.pShape = shape;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 50.0, 50.0);
        this.rescale = rescale;
    }

    public void draw(Graphics2D g, Shape shape, CyNetworkView networkView, View<? extends CyIdentifiable> view) {
        AffineTransform scale = AffineTransform.getScaleInstance(this.upscale, this.upscale);
        Shape lShape = scale.createTransformedShape(this.pShape);
        Rectangle2D lShapeBounds = lShape.getBounds2D();
        BufferedImage image = new BufferedImage((int)(lShapeBounds.getWidth() + this.radius * 4.0), (int)(lShapeBounds.getHeight() + this.radius * 4.0), 2);
        AffineTransform trans = AffineTransform.getTranslateInstance(-lShapeBounds.getX() + this.radius * 2.4, -lShapeBounds.getY() + this.radius * 2.4);
        Shape gShape = trans.createTransformedShape(lShape);
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(this.getPaint());
        g2.draw(gShape);
        g2.fill(gShape);
        g2.dispose();
        image = this.getGaussianBlurFilter((int)this.radius, true).filter(image, null);
        image = this.getGaussianBlurFilter((int)this.radius, false).filter(image, null);
        g.drawImage(image, (int)(this.pShape.getBounds2D().getX() - this.radius * 2.0 / this.upscale), (int)(this.pShape.getBounds2D().getY() - this.radius * 2.0 / this.upscale), (int)(this.pShape.getBounds2D().getWidth() + this.radius * 4.0 / this.upscale + 0.5), (int)(this.pShape.getBounds2D().getHeight() + this.radius * 4.0 / this.upscale + 0.5), null);
    }

    public Paint getPaint() {
        return new Color(0, 0, 0, 150);
    }

    public Paint getPaint(Rectangle2D bounds) {
        return new Color(0, 0, 0, 150);
    }

    public Shape getShape() {
        return this.pShape;
    }

    public Stroke getStroke() {
        return null;
    }

    public Paint getStrokePaint() {
        return null;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public ShadowLayer transform(AffineTransform xform) {
        this.bounds = xform.createTransformedShape(this.bounds).getBounds2D();
        this.pShape = ViewUtils.createPossiblyTransformedShape(xform, this.pShape, this.rescale);
        return this;
    }

    private BufferedImage changeImageWidth(BufferedImage image, int width) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int height = (int)((float)width / ratio);
        BufferedImage temp = new BufferedImage(width, height, image.getType());
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    private ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }
}

