/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public enum ColorGradients {
    REDGREEN("redgreen", Color.GREEN, null, Color.RED),
    REDBLUE("redblue", Color.RED, null, Color.BLUE),
    YELLOWWHITECYAN("yellowwhitecyan", Color.CYAN, Color.WHITE, Color.YELLOW),
    YELLOWCYAN("yellowcyan", Color.CYAN, null, Color.YELLOW),
    YELLOWBLACKCYAN("yellowblackcyan", Color.CYAN, Color.BLACK, Color.YELLOW),
    YELLOWBLUE("yellowblue", Color.BLUE, null, Color.YELLOW),
    ORANGEPURPLE("orangepurple", Color.ORANGE, null, Color.MAGENTA),
    BLUEGREENYELLOW("bluegreenyellow", Color.BLUE, Color.GREEN, Color.YELLOW),
    PURPLEYELLOW("purpleyellow", Color.MAGENTA, null, Color.YELLOW),
    GREENPURPLE("greenpurple", Color.GREEN, null, Color.MAGENTA),
    REDYELLOW("redyellow", Color.RED, null, Color.YELLOW);

    private Color up;
    private Color zero;
    private Color down;
    private String name;
    private static Map<String, ColorGradients> cMap;

    private ColorGradients(String name, Color down, Color zero, Color up) {
        this.name = name;
        this.up = up;
        this.down = down;
        this.zero = zero;
        this.addGradient(this);
    }

    public String getLabel() {
        return this.name;
    }

    private void addGradient(ColorGradients col) {
        if (cMap == null) {
            cMap = new HashMap<String, ColorGradients>();
        }
        cMap.put(col.getLabel(), col);
    }

    public Color[] getColors() {
        if (this.zero == null) {
            Color[] retColors = new Color[]{this.down, this.up};
            return retColors;
        }
        Color[] retColors = new Color[]{this.down, this.zero, this.up};
        return retColors;
    }

    public static Color[] getGradient(String name) {
        if (cMap.containsKey(name)) {
            return cMap.get(name).getColors();
        }
        return null;
    }
}

