/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts;

import edu.ucsf.rbvi.enhancedGraphics.internal.AbstractEnhancedCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ColorKeyword;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public abstract class AbstractChartCustomGraphics<T extends CustomGraphicLayer>
extends AbstractEnhancedCustomGraphics<T> {
    public static final String ANCHOR = "anchor";
    public static final String ALL = "all";
    public static final String ATTRIBUTELIST = "attributelist";
    public static final String BORDERWIDTH = "borderwidth";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String CLEAR = "clear";
    public static final String CURRENT = "current";
    public static final String LABELCOLOR = "labelcolor";
    public static final String LABELFONT = "labelfont";
    public static final String LABELOFFSET = "labeloffset";
    public static final String LABELSTYLE = "labelstyle";
    public static final String LABELSIZE = "labelsize";
    public static final String LABELWIDTH = "labelwidth";
    public static final String LABELSPACING = "labelspacing";
    public static final String LABELS = "labellist";
    public static final String LIST = "list";
    public static final String NETWORK = "network";
    public static final String NORMALIZE = "normalize";
    public static final String POSITION = "position";
    public static final String RANGE = "range";
    public static final String SCALE = "scale";
    public static final String SHOWLABELS = "showlabels";
    public static final String SHOWYAXIS = "showyaxis";
    public static final String SHOWXAXIS = "showxaxis";
    public static final String SIZE = "size";
    public static final String VALUES = "valuelist";
    public static final String YBASE = "ybase";
    protected List<Double> values = null;
    protected List<String> labels = null;
    protected List<String> attributes = null;
    protected double rangeMax = 0.0;
    protected double rangeMin = 0.0;
    protected double ybase = 0.5;
    protected double scale = 1.0;
    protected double borderWidth = 0.1;
    protected Color labelColor = Color.BLACK;
    protected Color borderColor = Color.BLACK;
    protected int labelSize = 8;
    protected String labelFont = "SansSerif";
    protected int labelStyle = 0;
    protected double labelWidth = Double.MAX_VALUE;
    protected double labelSpacing = 1.0;
    protected boolean normalized = false;
    protected List<? extends CustomGraphicLayer> shapeLayers = null;
    protected Object position = ViewUtils.Position.CENTER;
    protected Point2D labelOffset = null;
    protected Object anchor = ViewUtils.Position.CENTER;
    private static final String CONTRASTING = "contrasting";
    protected static final String DOWN = "down:";
    protected static final String MISSING = "missing:";
    private static final String MODULATED = "modulated";
    private static final String RAINBOW = "rainbow";
    private static final String RANDOM = "random";
    protected static final String UP = "up:";
    protected static final String ZERO = "zero:";
    private static final double EPSILON = (double)1.0E-8f;

    @Override
    public Image getRenderedImage() {
        if (this.shapeLayers == null) {
            return null;
        }
        Rectangle2D bounds = new Rectangle2D.Double();
        for (CustomGraphicLayer customGraphicLayer : this.shapeLayers) {
            bounds = bounds.createUnion(customGraphicLayer.getBounds2D());
        }
        BufferedImage image = new BufferedImage((int)bounds.getWidth() * 4, (int)bounds.getHeight() * 4, 2);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.translate(-bounds.getX() * 4.0, -bounds.getY() * 4.0);
        graphics2D.scale(4.0, 4.0);
        for (CustomGraphicLayer customGraphicLayer : this.shapeLayers) {
            if (customGraphicLayer instanceof PaintedShape) {
                PaintedShape ps = (PaintedShape)customGraphicLayer;
                Shape shape = ps.getShape();
                if (ps.getStroke() != null) {
                    Paint strokePaint = ps.getStrokePaint();
                    if (strokePaint == null) {
                        strokePaint = Color.BLACK;
                    }
                    graphics2D.setPaint(strokePaint);
                    graphics2D.setStroke(ps.getStroke());
                    graphics2D.draw(shape);
                }
                graphics2D.setPaint(ps.getPaint());
                graphics2D.fill(shape);
                continue;
            }
            if (!(customGraphicLayer instanceof Cy2DGraphicLayer)) continue;
        }
        return image;
    }

    protected void populateValues(Map<String, String> args) {
        double y;
        double x;
        String[] point;
        if (args.containsKey(RANGE)) {
            this.rangeMin = 0.0;
            this.rangeMax = 0.0;
            String[] split = args.get(RANGE).split(",");
            try {
                if (split.length == 2) {
                    this.rangeMin = this.getDoubleValue(split[0]);
                    this.rangeMax = this.getDoubleValue(split[1]);
                }
            }
            catch (NumberFormatException e) {
                this.rangeMin = 0.0;
                this.rangeMax = 0.0;
            }
            if (this.rangeMin == 0.0 && this.rangeMax == 0.0) {
                this.logger.warn((Object)("Unable to parse min/max values from '" + args.get(RANGE) + "'"));
            }
        }
        if (args.containsKey(BORDERWIDTH)) {
            try {
                this.borderWidth = this.getDoubleValue(args.get(BORDERWIDTH));
            }
            catch (NumberFormatException e) {
                this.logger.warn((Object)("Unable to parse border width from '" + args.get(BORDERWIDTH) + "'"));
            }
        }
        if (args.containsKey(BORDERCOLOR)) {
            this.borderColor = this.getColorValue(args.get(BORDERCOLOR));
        }
        if (args.containsKey(NORMALIZE)) {
            this.normalized = !this.getBooleanValue(args.get(NORMALIZE));
        }
        this.values = null;
        if (args.containsKey(VALUES)) {
            this.values = this.convertInputToDouble(args.get(VALUES));
            if (this.values == null) {
                this.logger.error((Object)("Cannot parse valuelist from input '" + args.get(VALUES) + "'"));
                return;
            }
            if (this.rangeMax != 0.0 || this.rangeMin != 0.0) {
                this.values = this.normalize(this.values, this.rangeMin, this.rangeMax);
                this.normalized = true;
            }
        }
        this.labels = new ArrayList<String>();
        if (args.containsKey(LABELS)) {
            this.labels = this.getStringList(args.get(LABELS));
            if (this.labels == null) {
                this.logger.error((Object)("Cannot parse labellist from input '" + args.get(LABELS) + "'"));
                return;
            }
        }
        boolean showLabels = true;
        if (args.containsKey(SHOWLABELS)) {
            showLabels = this.getBooleanValue(args.get(SHOWLABELS));
        }
        if (args.containsKey(LABELSIZE)) {
            this.labelSize = this.getIntegerValue(args.get(LABELSIZE));
        }
        if (args.containsKey(LABELFONT)) {
            this.labelFont = args.get(LABELFONT);
        }
        if (args.containsKey(LABELSTYLE)) {
            this.labelStyle = this.getFontStyle(args.get(LABELSTYLE));
        }
        if (args.containsKey(LABELWIDTH)) {
            this.labelWidth = this.getDoubleValue(args.get(LABELWIDTH));
        }
        if (args.containsKey(LABELSPACING)) {
            this.labelSpacing = this.getDoubleValue(args.get(LABELSPACING));
        }
        if (args.containsKey(LABELCOLOR)) {
            this.labelColor = this.getColorValue(args.get(LABELCOLOR));
        }
        if (args.containsKey(SCALE)) {
            try {
                this.scale = this.getDoubleValue(args.get(SCALE));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (args.containsKey(POSITION)) {
            String pos = args.get(POSITION);
            this.position = ViewUtils.getPosition(pos);
            if (this.position == null) {
                if (pos.indexOf(",") > 0 && (point = pos.split(",")).length == 2) {
                    x = Double.parseDouble(point[0]);
                    y = Double.parseDouble(point[1]);
                    this.position = new Point2D.Double(x, y);
                }
                if (this.position == null) {
                    this.logger.warn((Object)("Cannot parse position from input '" + pos + "'"));
                    return;
                }
            }
        }
        if (args.containsKey(LABELOFFSET)) {
            String offset = args.get(LABELOFFSET);
            if (offset.indexOf(",") > 0 && (point = offset.split(",")).length == 2) {
                x = Double.parseDouble(point[0]);
                y = Double.parseDouble(point[1]);
                this.labelOffset = new Point2D.Double(x, y);
            }
            if (this.labelOffset == null) {
                this.logger.warn((Object)("Cannot parse labeloffset from input '" + offset + "'"));
                return;
            }
        }
        if (args.containsKey(ANCHOR)) {
            String a = args.get(ANCHOR);
            this.anchor = ViewUtils.getPosition(a);
            if (this.anchor == null) {
                this.logger.warn((Object)("Cannot parse anchor from input '" + a + "'"));
                return;
            }
        }
        Rectangle2D size = null;
        if (args.containsKey(SIZE)) {
            String sizeString = args.get(SIZE);
            size = this.getSize(sizeString);
        }
        if (args.containsKey(YBASE)) {
            String yb = args.get(YBASE);
            if (yb.equalsIgnoreCase("bottom")) {
                this.ybase = 1.0;
            } else if (yb.equalsIgnoreCase("top")) {
                this.ybase = 0.0;
            } else if (yb.equalsIgnoreCase("middle")) {
                this.ybase = 0.5;
            } else {
                try {
                    this.ybase = this.getDoubleValue(yb);
                }
                catch (NumberFormatException e) {
                    this.logger.warn((Object)("Cannot parse ybase from input '" + args.get(YBASE) + "'"));
                    this.ybase = 0.5;
                }
            }
        }
        if (!showLabels) {
            this.labels = null;
        }
        if (args.containsKey(ATTRIBUTELIST)) {
            this.attributes = this.getStringList(args.get(ATTRIBUTELIST));
            if (this.attributes == null || this.attributes.size() == 0) {
                this.logger.error((Object)("Cannot parse attributelist from input '" + args.get(ATTRIBUTELIST) + "'"));
            }
        }
    }

    public List<Double> convertInputToDouble(String input) {
        return this.parseStringList(input);
    }

    public String getLabelFromAttribute(CyNetwork network, CyNode node, String attribute) {
        if (attribute == null) {
            return null;
        }
        CyRow row = network.getRow((CyIdentifiable)node);
        if (row == null) {
            this.logger.warn((Object)("Cannot find row for node " + node));
            return null;
        }
        Object label = row.getRaw(attribute);
        if (label == null) {
            this.logger.warn((Object)("Cannot find attribute '" + attribute + "' for node " + node));
            return null;
        }
        return label.toString();
    }

    public List<Double> getDataFromAttributes(CyNetwork network, CyNode node, List<String> attributeList, List<String> labels) {
        List<Double> values = new ArrayList<Double>();
        CyRow row = network.getRow((CyIdentifiable)node);
        if (row == null) {
            this.logger.warn((Object)("Cannot find row for node " + node));
            return values;
        }
        CyTable table = row.getTable();
        String column = attributeList.get(0);
        if (column == null || table.getColumn(column) == null) {
            this.logger.warn((Object)("Cannot find node attribute column " + attributeList.get(0)));
            return values;
        }
        Class columnType = table.getColumn(column).getType();
        if (attributeList.size() == 1 && columnType.equals(List.class)) {
            Class type = table.getColumn(column).getListElementType();
            if (type == Double.class) {
                List dList = row.getList(column, Double.class);
                if (dList != null) {
                    values.addAll(dList);
                }
            } else if (type == Integer.class) {
                List iList = row.getList(column, Integer.class);
                for (Integer i : iList) {
                    values.add(i.doubleValue());
                }
            } else if (type == Long.class) {
                List lList = row.getList(column, Long.class);
                for (Long l : lList) {
                    values.add(l.doubleValue());
                }
            } else if (type == Float.class) {
                List fList = row.getList(column, Float.class);
                for (Float f : fList) {
                    values.add(f.doubleValue());
                }
            } else if (type == String.class) {
                List sList = row.getList(column, String.class);
                for (String s : sList) {
                    values.add(Double.valueOf(s));
                }
            }
        } else {
            for (String col : attributeList) {
                if (table.getColumn(col) == null) continue;
                Class type = table.getColumn(col).getType();
                if (type == Double.class) {
                    values.add((Double)row.get(col, Double.class));
                    continue;
                }
                if (type == Integer.class) {
                    Integer i = (Integer)row.get(col, Integer.class);
                    values.add(i.doubleValue());
                    continue;
                }
                if (type == Float.class) {
                    Float f = (Float)row.get(col, Float.class);
                    values.add(f.doubleValue());
                    continue;
                }
                if (type != String.class) continue;
                String s = (String)row.get(col, String.class);
                values.add(Double.valueOf(s));
            }
        }
        if (this.rangeMax != 0.0 || this.rangeMin != 0.0) {
            values = this.normalize(values, this.rangeMin, this.rangeMax);
            this.normalized = true;
        }
        if (labels != null && labels.size() == 0) {
            labels.addAll(attributeList);
        }
        return values;
    }

    public List<Double> convertStringList(List<String> input) {
        ArrayList<Double> values = new ArrayList<Double>(input.size());
        for (String s : input) {
            try {
                Double d = Double.valueOf(s);
                values.add(d);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return values;
    }

    public List<Double> convertIntegerList(List<Integer> input) {
        ArrayList<Double> values = new ArrayList<Double>(input.size());
        for (Integer s : input) {
            double d = s.doubleValue();
            values.add(d);
        }
        return values;
    }

    public List<Double> parseStringList(String input) {
        if (input == null) {
            return null;
        }
        String[] inputArray = input.split(",");
        return this.convertStringList(Arrays.asList(inputArray));
    }

    private String[] unescape(String[] strs) {
        String[] unescaped_strs = new String[strs.length];
        int j = 0;
        for (String str : strs) {
            StringBuilder sb = new StringBuilder();
            boolean deleted = false;
            for (int i = 0; i < str.length(); ++i) {
                char curChar = str.charAt(i);
                if (curChar != '\\' || deleted) {
                    sb.append(curChar);
                    deleted = false;
                    continue;
                }
                deleted = true;
            }
            unescaped_strs[j++] = sb.toString();
        }
        return unescaped_strs;
    }

    public List<String> getStringList(String input) {
        if (input == null || input.length() == 0) {
            return new ArrayList<String>();
        }
        String[] inputArray = this.unescape(input.split("(?<!\\\\),", -1));
        return Arrays.asList(inputArray);
    }

    public boolean getBooleanValue(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        return Boolean.parseBoolean(input.toString());
    }

    public int getFontStyle(String input) {
        if (input.equalsIgnoreCase("italics")) {
            return 2;
        }
        if (input.equalsIgnoreCase("bold")) {
            return 1;
        }
        if (input.equalsIgnoreCase("bolditalic")) {
            return 3;
        }
        return 0;
    }

    public Color getColorValue(String input) {
        String[] colorArray = new String[]{input};
        List<Color> colors = this.parseColorList(colorArray);
        return colors.get(0);
    }

    public double getDoubleValue(Object input) throws NumberFormatException {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Integer) {
            return ((Integer)input).doubleValue();
        }
        if (input instanceof String) {
            return Double.parseDouble((String)input);
        }
        throw new NumberFormatException("input can not be converted to double");
    }

    public int getIntegerValue(Object input) throws NumberFormatException {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof String) {
            return Integer.parseInt((String)input);
        }
        throw new NumberFormatException("input can not be converted to integer");
    }

    public Rectangle2D getSize(Object input) {
        if (input instanceof Rectangle2D) {
            return (Rectangle2D)input;
        }
        if (input instanceof Double) {
            double v = (Double)input;
            return new Rectangle2D.Double(0.0, 0.0, v, v);
        }
        if (input instanceof Integer) {
            double v = ((Integer)input).doubleValue();
            return new Rectangle2D.Double(0.0, 0.0, v, v);
        }
        if (input instanceof String) {
            String inputString = (String)input;
            String[] sizes = inputString.split("[xX]");
            if (sizes.length == 1) {
                double v = Double.parseDouble(sizes[0]);
                return new Rectangle2D.Double(0.0, 0.0, v, v);
            }
            if (sizes.length == 2) {
                double h = Double.parseDouble(sizes[0]);
                double w = Double.parseDouble(sizes[1]);
                return new Rectangle2D.Double(0.0, 0.0, w, h);
            }
        }
        return null;
    }

    public Font getFont() {
        return new Font(this.labelFont, this.labelStyle, this.labelSize);
    }

    public List<Double> arrayMax(List<Double> maxValues, List<Double> values) {
        if (maxValues == null) {
            maxValues = new ArrayList<Double>(values.size());
            for (Double d : values) {
                maxValues.add(Math.abs(d));
            }
            return maxValues;
        }
        for (int index = 0; index < values.size(); ++index) {
            maxValues.set(index, Math.max(maxValues.get(index), Math.abs(values.get(index))));
        }
        return maxValues;
    }

    public void normalize(List<Double> values, List<Double> maxValues) {
        for (int index = 0; index < values.size(); ++index) {
            values.set(index, values.get(index) / maxValues.get(index));
        }
    }

    public Map<String, String> serializeArgMap(Map<String, Object> argMap) {
        HashMap<String, String> sMap = new HashMap<String, String>();
        for (String key : argMap.keySet()) {
            sMap.put(key, this.serializeObject(argMap.get(key)));
        }
        return sMap;
    }

    private String serializeObject(Object obj) {
        String result;
        if (obj instanceof List) {
            result = "";
            for (Object o : (List)obj) {
                result = result + o.toString() + ",";
            }
            result = result.substring(0, result.length() - 1);
        } else {
            result = obj.toString();
        }
        return result;
    }

    public List<Color> convertInputToColor(String input, List<Double> values) {
        int nColors = values.size();
        if (input == null) {
            return this.generateContrastingColors(nColors);
        }
        String[] colorArray = input.split(",");
        if (colorArray.length == 2 && (colorArray[0].toLowerCase().startsWith(UP) || colorArray[0].toLowerCase().startsWith(DOWN))) {
            return this.parseUpDownColor(colorArray, values);
        }
        if (colorArray.length == 3 && (colorArray[0].toLowerCase().startsWith(UP) || colorArray[0].toLowerCase().startsWith(DOWN) || colorArray[0].toLowerCase().startsWith(ZERO))) {
            return this.parseUpDownColor(colorArray, values);
        }
        if (colorArray.length == 4 && (colorArray[0].toLowerCase().startsWith(UP) || colorArray[0].toLowerCase().startsWith(DOWN) || colorArray[0].toLowerCase().startsWith(ZERO) || colorArray[0].toLowerCase().startsWith(MISSING))) {
            return this.parseUpDownColor(colorArray, values);
        }
        if (colorArray.length > 1) {
            return this.parseColorList(colorArray);
        }
        return this.parseColorKeyword(input.trim(), nColors);
    }

    public List<Color> parseUpDownColor(String[] colorArray) {
        if (colorArray.length < 2) {
            return null;
        }
        String[] colors = new String[4];
        colors[2] = "black";
        colors[3] = "grey";
        for (int index = 0; index < colorArray.length; ++index) {
            if (colorArray[index].toLowerCase().startsWith(UP)) {
                colors[0] = colorArray[index].substring(UP.length());
                continue;
            }
            if (colorArray[index].toLowerCase().startsWith(DOWN)) {
                colors[1] = colorArray[index].substring(DOWN.length());
                continue;
            }
            if (colorArray[index].toLowerCase().startsWith(ZERO)) {
                colors[2] = colorArray[index].substring(ZERO.length());
                continue;
            }
            if (!colorArray[index].toLowerCase().startsWith(MISSING)) continue;
            colors[3] = colorArray[index].substring(MISSING.length());
        }
        return this.parseColorList(colors);
    }

    private List<Color> parseUpDownColor(String[] colorArray, List<Double> values) {
        List<Color> upDownColors = this.parseUpDownColor(colorArray);
        Color up = upDownColors.get(0);
        Color down = upDownColors.get(1);
        Color zero = upDownColors.get(2);
        Color missing = upDownColors.get(3);
        ArrayList<Color> results = new ArrayList<Color>(values.size());
        for (Double v : values) {
            if (v == null || v.isNaN()) {
                results.add(missing);
                continue;
            }
            double vn = v;
            if (!this.normalized) {
                vn = this.normalize(v, this.rangeMin, this.rangeMax);
            }
            if (vn < (double)-1.0E-8f) {
                results.add(this.scaleColor(-vn, zero, down));
                continue;
            }
            if (vn > (double)1.0E-8f) {
                results.add(this.scaleColor(vn, zero, up));
                continue;
            }
            results.add(zero);
        }
        return results;
    }

    private Color scaleColor(double v, Color zero, Color c) {
        if (this.rangeMin == 0.0 && this.rangeMax == 0.0) {
            return c;
        }
        if (v < 0.0 || v > 1.0) {
            this.logger.warn((Object)"Warning, one color was out-of-range and replaced by the up or down color.\nMaybe you should not use a scaling color scheme.");
            return c;
        }
        int b = (int)((double)c.getBlue() * v + (double)zero.getBlue() * (1.0 - v));
        int r = (int)((double)c.getRed() * v + (double)zero.getRed() * (1.0 - v));
        int g = (int)((double)c.getGreen() * v + (double)zero.getGreen() * (1.0 - v));
        int a = (int)((double)c.getAlpha() * v + (double)zero.getAlpha() * (1.0 - v));
        return new Color(r, g, b, a);
    }

    private double normalize(double v, double rangeMin, double rangeMax) {
        if (Double.isNaN(v)) {
            return v;
        }
        if (rangeMin == 0.0 && rangeMax == 0.0) {
            return v;
        }
        double range = rangeMax - rangeMin;
        double val = 0.0;
        if (v < rangeMin) {
            v = rangeMin;
        }
        if (v > rangeMax) {
            v = rangeMax;
        }
        if (rangeMin > 0.0 && rangeMax > 0.0) {
            val = (v - rangeMin) / range;
        } else if (rangeMin < 0.0 && rangeMax < 0.0) {
            val = (v - rangeMax) / range;
        } else if (v < 0.0 && rangeMin < 0.0) {
            val = -(v / rangeMin);
        } else if (v > 0.0 && rangeMax > 0.0) {
            val = v / rangeMax;
        }
        return val;
    }

    protected List<Double> normalize(List<Double> vList, double rangeMin, double rangeMax) {
        for (int i = 0; i < vList.size(); ++i) {
            Double v = vList.get(i);
            if (v == null) continue;
            Double vn = this.normalize(v, rangeMin, rangeMax);
            vList.set(i, vn);
        }
        return vList;
    }

    private List<Color> parseColorKeyword(String input, int nColors) {
        if (input.equals(RANDOM)) {
            return this.generateRandomColors(nColors);
        }
        if (input.equals(RAINBOW)) {
            return this.generateRainbowColors(nColors);
        }
        if (input.equals(MODULATED)) {
            return this.generateModulatedRainbowColors(nColors);
        }
        if (input.equals(CONTRASTING)) {
            return this.generateContrastingColors(nColors);
        }
        String[] colorArray = new String[]{input};
        List<Color> colors = this.parseColorList(colorArray);
        return colors;
    }

    public Color parseColor(String colorString) {
        if (colorString == null) {
            return null;
        }
        if ((colorString = colorString.trim()).matches("^#([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})$")) {
            int r = Integer.parseInt(colorString.substring(1, 3), 16);
            int g = Integer.parseInt(colorString.substring(3, 5), 16);
            int b = Integer.parseInt(colorString.substring(5, 7), 16);
            if (colorString.length() > 7) {
                int a = Integer.parseInt(colorString.substring(7, 9), 16);
                return new Color(r, g, b, a);
            }
            return new Color(r, g, b);
        }
        Color c = ColorKeyword.getColor(colorString);
        if (c == null) {
            this.logger.warn((Object)("Can't find color '" + colorString + "'"));
            return null;
        }
        return c;
    }

    public List<Color> parseColorList(String[] inputArray) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String colorString : inputArray) {
            if (colorString == null) continue;
            if ((colorString = colorString.trim()).matches("^#([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})$")) {
                int r = Integer.parseInt(colorString.substring(1, 3), 16);
                int g = Integer.parseInt(colorString.substring(3, 5), 16);
                int b = Integer.parseInt(colorString.substring(5, 7), 16);
                if (colorString.length() > 7) {
                    int a = Integer.parseInt(colorString.substring(7, 9), 16);
                    colors.add(new Color(r, g, b, a));
                    continue;
                }
                colors.add(new Color(r, g, b));
                continue;
            }
            Color c = ColorKeyword.getColor(colorString);
            if (c == null) {
                this.logger.warn((Object)("Can't find color '" + colorString + "'"));
                return null;
            }
            colors.add(c);
        }
        return colors;
    }

    private List<Color> generateRandomColors(int nColors) {
        Calendar cal = Calendar.getInstance();
        int seed = cal.get(13);
        Random rand = new Random(seed);
        ArrayList<Color> result = new ArrayList<Color>(nColors);
        for (int index = 0; index < nColors; ++index) {
            int r = rand.nextInt(255);
            int g = rand.nextInt(255);
            int b = rand.nextInt(255);
            result.add(index, new Color(r, g, b, 200));
        }
        return result;
    }

    private List<Color> generateRainbowColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        for (float i = 0.0f; i < (float)nColors; i += 1.0f) {
            values.add(new Color(Color.HSBtoRGB(i / (float)nColors, 1.0f, 1.0f)));
        }
        return values;
    }

    private List<Color> generateModulatedRainbowColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        for (float i = 0.0f; i < (float)nColors; i += 1.0f) {
            float sat = Math.abs(((Number)Math.cos((double)(8.0f * i) / (Math.PI * 2))).floatValue()) * 0.7f + 0.3f;
            float br = Math.abs(((Number)Math.sin((double)i / (Math.PI * 2) + 1.5707963267948966)).floatValue()) * 0.7f + 0.3f;
            values.add(new Color(Color.HSBtoRGB(i / (float)nColors, sat, br)));
        }
        return values;
    }

    private List<Color> generateContrastingColors(int nColors) {
        ArrayList<Color> values = new ArrayList<Color>();
        for (int i = 0; i < nColors; ++i) {
            float hue = i % 2 == 1 ? (float)i / (float)nColors + 0.5f : (float)i / (float)nColors;
            Color rgbColor = new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f));
            values.add(rgbColor);
        }
        return values;
    }
}

