/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.bar.BarChartFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.circos.CircosChartFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.heatstrip.HeatStripFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.label.LabelFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.line.LineChartFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.pie.PieChartFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.stripe.StripeChartFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.linear.LinearGradientCGFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.radial.RadialGradientCGFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.tasks.ListChartsTaskFactory;
import edu.ucsf.rbvi.enhancedGraphics.internal.tasks.VersionTaskFactory;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphicsFactory;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public void start(BundleContext bc) {
        CyApplicationManager cyApplicationManagerServiceRef = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        String version = bc.getBundle().getVersion().toString();
        ArrayList<CyCustomGraphicsFactory> charts = new ArrayList<CyCustomGraphicsFactory>();
        charts.add(new LinearGradientCGFactory());
        charts.add(new RadialGradientCGFactory());
        charts.add(new PieChartFactory());
        charts.add(new BarChartFactory());
        charts.add(new LabelFactory());
        charts.add(new LineChartFactory());
        charts.add(new StripeChartFactory());
        charts.add(new HeatStripFactory());
        charts.add(new CircosChartFactory());
        for (CyCustomGraphicsFactory chart : charts) {
            Properties chartProps = new Properties();
            this.registerService(bc, chart, CyCustomGraphicsFactory.class, chartProps);
        }
        ListChartsTaskFactory listFactory = new ListChartsTaskFactory(charts);
        Properties listChartProps = new Properties();
        listChartProps.setProperty("commandNamespace", "enhancedGraphics");
        listChartProps.setProperty("command", "list");
        this.registerService(bc, (Object)listFactory, TaskFactory.class, listChartProps);
        VersionTaskFactory versionFactory = new VersionTaskFactory(version);
        Properties versionProps = new Properties();
        versionProps.setProperty("commandNamespace", "enhancedGraphics");
        versionProps.setProperty("command", "version");
        this.registerService(bc, (Object)versionFactory, TaskFactory.class, versionProps);
        this.logger.info((Object)"Enhanced Custom Graphics started");
    }
}

