/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;

public abstract class AbstractEnhancedCustomGraphics<T extends CustomGraphicLayer>
implements CyCustomGraphics<T> {
    protected Long id = null;
    protected float fitRatio = 1.0f;
    protected List<T> layers = new ArrayList<T>();
    protected String displayName;
    protected int width = 50;
    protected int height = 50;
    protected Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    protected AbstractEnhancedCustomGraphics() {
    }

    public Long getIdentifier() {
        return this.id;
    }

    public void setIdentifier(Long id) {
        this.id = id;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<T> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        return this.layers;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public float getFitRatio() {
        return this.fitRatio;
    }

    public void setFitRatio(float fitRatio) {
        this.fitRatio = fitRatio;
    }

    public String toString() {
        return this.displayName;
    }

    public abstract Image getRenderedImage();

    public abstract String toSerializableString();

    protected Map<String, String> parseInput(String input) {
        HashMap<String, String> settings = new HashMap<String, String>();
        StringReader reader = new StringReader(input);
        StreamTokenizer st = new StreamTokenizer(reader);
        st.ordinaryChar(47);
        st.ordinaryChar(95);
        st.ordinaryChar(45);
        st.ordinaryChar(46);
        st.ordinaryChars(48, 57);
        st.wordChars(47, 47);
        st.wordChars(95, 95);
        st.wordChars(45, 45);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        ArrayList<String> tokenList = new ArrayList<String>();
        int tokenIndex = 0;
        try {
            int i;
            block6: while ((i = st.nextToken()) != -1) {
                switch (i) {
                    case 61: {
                        i = st.nextToken();
                        if (i != -3 && i != 34) continue block6;
                        String key = (String)tokenList.get(--tokenIndex);
                        settings.put(key, st.sval);
                        tokenList.remove(tokenIndex);
                        continue block6;
                    }
                    case -3: 
                    case 34: {
                        tokenList.add(st.sval);
                        ++tokenIndex;
                        continue block6;
                    }
                }
            }
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
        return settings;
    }

    protected Point2D parsePoint(String point) {
        if (point == null || point.length() == 0) {
            return null;
        }
        String[] tokens = point.split(",");
        if (tokens.length != 2) {
            return null;
        }
        try {
            float x = Float.parseFloat(tokens[0].trim());
            float y = Float.parseFloat(tokens[1].trim());
            return new Point2D.Float(x, y);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected int parseStopList(String stoplist, List<Color> colors, List<Float> stops) {
        String[] tokens;
        if (stoplist == null || stoplist.length() == 0) {
            return 0;
        }
        int nStops = 0;
        for (String token : tokens = stoplist.split("\\|")) {
            float stop;
            String[] components = token.split(",");
            if (components.length != 4 && components.length != 5) {
                this.logger.warn((Object)("Unable to get stop from '" + token + "'.  Skipping this stop"));
                continue;
            }
            int r = Integer.parseInt(components[0]);
            int g = Integer.parseInt(components[1]);
            int b = Integer.parseInt(components[2]);
            int a = 255;
            if (components.length == 5) {
                a = Integer.parseInt(components[3]);
                stop = Float.parseFloat(components[4]);
            } else {
                stop = Float.parseFloat(components[3]);
            }
            colors.add(new Color(r, g, b, a));
            stops.add(Float.valueOf(stop));
            ++nStops;
        }
        return nStops;
    }
}

