/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.Integrator;
import prefuse.util.force.RungeKuttaIntegrator;
import prefuse.util.force.Spring;
import prefuse.util.force.StateMonitor;

public class ForceSimulator {
    private ArrayList<ForceItem> items;
    private ArrayList<Spring> springs;
    private Force[] iforces;
    private Force[] sforces;
    private int iflen;
    private int sflen;
    private Integrator integrator;
    private float speedLimit = 1.0f;
    private final StateMonitor monitor;

    public ForceSimulator(StateMonitor monitor) {
        this(new RungeKuttaIntegrator(monitor), monitor);
    }

    public ForceSimulator(Integrator integrator, StateMonitor monitor) {
        this.integrator = integrator;
        this.monitor = monitor;
        this.iforces = new Force[5];
        this.sforces = new Force[5];
        this.iflen = 0;
        this.sflen = 0;
        this.items = new ArrayList();
        this.springs = new ArrayList();
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float limit) {
        this.speedLimit = limit;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(Integrator intgr) {
        this.integrator = intgr;
    }

    public void clear() {
        this.items.clear();
        Iterator<Spring> siter = this.springs.iterator();
        Spring.SpringFactory f = Spring.getFactory();
        while (siter.hasNext()) {
            f.reclaim(siter.next());
        }
        this.springs.clear();
    }

    public void addForce(Force f) {
        Force[] newf;
        if (f.isItemForce()) {
            if (this.iforces.length == this.iflen) {
                newf = new Force[this.iflen + 10];
                System.arraycopy(this.iforces, 0, newf, 0, this.iforces.length);
                this.iforces = newf;
            }
            this.iforces[this.iflen++] = f;
        }
        if (f.isSpringForce()) {
            if (this.sforces.length == this.sflen) {
                newf = new Force[this.sflen + 10];
                System.arraycopy(this.sforces, 0, newf, 0, this.sforces.length);
                this.sforces = newf;
            }
            this.sforces[this.sflen++] = f;
        }
    }

    public Force[] getForces() {
        Force[] rv = new Force[this.iflen + this.sflen];
        System.arraycopy(this.iforces, 0, rv, 0, this.iflen);
        System.arraycopy(this.sforces, 0, rv, this.iflen, this.sflen);
        return rv;
    }

    public void addItem(ForceItem item) {
        this.items.add(item);
    }

    public boolean removeItem(ForceItem item) {
        return this.items.remove(item);
    }

    public Iterator<ForceItem> getItems() {
        return this.items.iterator();
    }

    public Spring addSpring(ForceItem item1, ForceItem item2) {
        return this.addSpring(item1, item2, -1.0f, -1.0f);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float length) {
        return this.addSpring(item1, item2, -1.0f, length);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float coeff, float length) {
        if (item1 == null || item2 == null) {
            throw new IllegalArgumentException("ForceItems must be non-null");
        }
        Spring s = Spring.getFactory().getSpring(item1, item2, coeff, length);
        this.springs.add(s);
        return s;
    }

    public Iterator<Spring> getSprings() {
        return this.springs.iterator();
    }

    public void runSimulator(long timestep) {
        if (!this.monitor.isCancelled()) {
            this.accumulate();
        }
        if (!this.monitor.isCancelled()) {
            this.integrator.integrate(this, timestep);
        }
    }

    protected void accumulate() {
        int i;
        for (i = 0; i < this.iflen && !this.monitor.isCancelled(); ++i) {
            this.iforces[i].init(this);
        }
        for (i = 0; i < this.sflen && !this.monitor.isCancelled(); ++i) {
            this.sforces[i].init(this);
        }
        this.updateForceItems(this.items);
        this.updateSprings(this.springs);
    }

    private void updateForceItems(Collection<ForceItem> list) {
        for (ForceItem item : list) {
            if (this.monitor.isCancelled()) {
                return;
            }
            item.force[0] = 0.0f;
            item.force[1] = 0.0f;
            for (int i = 0; i < this.iflen && !this.monitor.isCancelled(); ++i) {
                this.iforces[i].getForce(item);
            }
        }
    }

    private void updateSprings(Collection<Spring> list) {
        for (Spring s : list) {
            if (this.monitor.isCancelled()) {
                return;
            }
            for (int i = 0; i < this.sflen && !this.monitor.isCancelled(); ++i) {
                this.sforces[i].getForce(s);
            }
        }
    }
}

