/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.view;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.events.GroupAboutToBeDestroyedEvent;
import org.cytoscape.group.events.GroupAboutToBeDestroyedListener;
import org.cytoscape.group.events.GroupAboutToBeRemovedEvent;
import org.cytoscape.group.events.GroupAboutToBeRemovedListener;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.group.internal.view.ViewUtils;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.model.events.ViewChangedListener;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;

public class NodeChangeListener
implements ViewChangedListener,
GroupAboutToBeDestroyedListener,
GroupAboutToBeRemovedListener,
SessionAboutToBeLoadedListener,
NetworkViewAboutToBeDestroyedListener {
    private final CyGroupManagerImpl cyGroupManager;
    private final CyGroupSettingsImpl cyGroupSettings;
    private VisualMappingManager cyStyleManager;
    Map<CyNetworkView, Set<CyNode>> groupMap;
    Map<CyNetworkView, Set<CyNode>> nodeMap;
    Map<CyNetworkView, Map<CyNode, CyGroup>> node2GroupMap;
    boolean ignoreChanges = false;

    public NodeChangeListener(CyGroupManagerImpl groupManager, CyGroupSettingsImpl cyGroupSettings) {
        this.cyGroupManager = groupManager;
        this.cyGroupSettings = cyGroupSettings;
        this.groupMap = new HashMap<CyNetworkView, Set<CyNode>>();
        this.nodeMap = new HashMap<CyNetworkView, Set<CyNode>>();
        this.node2GroupMap = new HashMap<CyNetworkView, Map<CyNode, CyGroup>>();
    }

    public void handleEvent(GroupAboutToBeDestroyedEvent e) {
        CyGroup source = e.getGroup();
        Object removeView = null;
        ArrayList<CyNetworkView> viewsToRemove = new ArrayList<CyNetworkView>();
        for (CyNetworkView view : this.groupMap.keySet()) {
            if (!this.groupMap.get(view).contains(source.getGroupNode())) continue;
            viewsToRemove.add(view);
        }
        for (CyNetworkView view : viewsToRemove) {
            this.removeGroup(source, view);
        }
    }

    public void handleEvent(GroupAboutToBeRemovedEvent e) {
        CyGroup source = (CyGroup)e.getSource();
        CyNetwork net = e.getNetwork();
        CyNetworkView removeView = null;
        for (CyNetworkView view : this.groupMap.keySet()) {
            if (!((CyNetwork)view.getModel()).equals(net)) continue;
            removeView = view;
            break;
        }
        if (removeView != null) {
            this.removeGroup(source, removeView);
        }
    }

    public void handleEvent(ViewChangedEvent<?> e) {
        if (this.ignoreChanges) {
            return;
        }
        CyNetworkView networkView = (CyNetworkView)e.getSource();
        if (!this.groupMap.containsKey(networkView)) {
            return;
        }
        Set<CyNode> groupNodes = this.groupMap.get(networkView);
        Set<CyNode> nodes = this.nodeMap.get(networkView);
        Collection payload = e.getPayloadCollection();
        for (ViewChangeRecord vcr : payload) {
            if (!(vcr.getView().getModel() instanceof CyNode)) continue;
            View nodeView = vcr.getView();
            VisualProperty property = vcr.getVisualProperty();
            if (!property.equals(BasicVisualLexicon.NODE_X_LOCATION) && !property.equals(BasicVisualLexicon.NODE_Y_LOCATION) && !property.equals(BasicVisualLexicon.NODE_WIDTH) && !property.equals(BasicVisualLexicon.NODE_HEIGHT)) continue;
            CyNode node = (CyNode)nodeView.getModel();
            if (groupNodes.contains(node)) {
                try {
                    this.updateGroupLocation(networkView, (View<CyNode>)nodeView);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            try {
                this.updateNodeLocation(networkView, (View<CyNode>)nodeView);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        CyEventHelper cyEventHelper = this.cyGroupManager.getService(CyEventHelper.class);
        cyEventHelper.flushPayloadEvents(e.getSource());
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent e) {
        CyNetworkView view = e.getNetworkView();
        this.groupMap.remove(view);
        this.nodeMap.remove(view);
        this.node2GroupMap.remove(view);
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.groupMap = new HashMap<CyNetworkView, Set<CyNode>>();
        this.nodeMap = new HashMap<CyNetworkView, Set<CyNode>>();
        this.node2GroupMap = new HashMap<CyNetworkView, Map<CyNode, CyGroup>>();
    }

    public void addGroup(CyGroup group, CyNetworkView networkView) {
        if (!this.groupMap.containsKey(networkView)) {
            this.groupMap.put(networkView, new HashSet());
        }
        this.groupMap.get(networkView).add(group.getGroupNode());
        if (!this.nodeMap.containsKey(networkView)) {
            this.nodeMap.put(networkView, new HashSet());
        }
        if (!this.node2GroupMap.containsKey(networkView)) {
            this.node2GroupMap.put(networkView, new HashMap());
        }
        Map<CyNode, CyGroup> node2Group = this.node2GroupMap.get(networkView);
        for (CyNode node : group.getNodeList()) {
            if (node2Group.containsKey(node)) continue;
            this.nodeMap.get(networkView).add(node);
            node2Group.put(node, group);
        }
    }

    public void removeGroup(CyGroup group, CyNetworkView networkView) {
        if (this.groupMap.containsKey(networkView)) {
            Set<CyNode> groups = this.groupMap.get(networkView);
            groups.remove(group.getGroupNode());
            if (groups.size() == 0) {
                this.groupMap.remove(networkView);
            }
        }
        Map<CyNode, CyGroup> node2Group = null;
        if (this.node2GroupMap.containsKey(networkView)) {
            node2Group = this.node2GroupMap.get(networkView);
        }
        if (node2Group != null) {
            node2Group.remove(group.getGroupNode());
        }
        if (this.nodeMap.containsKey(networkView)) {
            Set<CyNode> nodes = this.nodeMap.get(networkView);
            for (CyNode node : group.getNodeList()) {
                nodes.remove(node);
                if (node2Group == null) continue;
                node2Group.remove(node);
            }
            if (nodes.size() == 0) {
                this.nodeMap.remove(networkView);
            }
        }
    }

    private void updateGroupLocation(CyNetworkView networkView, View<CyNode> nodeView) {
        double groupX = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double groupY = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        CyGroup group = this.cyGroupManager.getGroup((CyNode)nodeView.getModel(), (CyNetwork)networkView.getModel());
        if (group == null) {
            return;
        }
        CyEventHelper cyEventHelper = this.cyGroupManager.getService(CyEventHelper.class);
        Dimension lastPosition = ViewUtils.getLocation((CyNetwork)networkView.getModel(), group);
        double xOffset = lastPosition.getWidth() - groupX;
        double yOffset = lastPosition.getHeight() - groupY;
        ArrayList<View> groupNodeList = new ArrayList<View>();
        boolean lastIgnoreChanges = this.ignoreChanges;
        this.ignoreChanges = true;
        for (CyNode node : group.getNodeList()) {
            View nv = networkView.getNodeView(node);
            if (nv == null) continue;
            double x = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            Dimension d = new Dimension();
            d.setSize(x - xOffset, y - yOffset);
            ViewUtils.moveNode(networkView, node, d);
            if (!this.cyGroupManager.isGroup(node, (CyNetwork)networkView.getModel())) continue;
            groupNodeList.add(nv);
        }
        ViewUtils.updateGroupLocation((CyNetwork)networkView.getModel(), group, groupX, groupY);
        if (groupNodeList.size() > 0) {
            for (View nv : groupNodeList) {
                this.updateGroupLocation(networkView, (View<CyNode>)nv);
            }
        }
        this.ignoreChanges = lastIgnoreChanges;
        cyEventHelper.flushPayloadEvents();
    }

    private void updateNodeLocation(CyNetworkView networkView, View<CyNode> nodeView) {
        View nv;
        if (nodeView == null) {
            return;
        }
        CyNode node = (CyNode)nodeView.getModel();
        CyGroup group = this.node2GroupMap.get(networkView).get(node);
        if (group == null) {
            group = this.getGroupForNode(node, networkView);
            if (group == null) {
                return;
            }
            this.node2GroupMap.get(networkView).put(node, group);
        }
        if (this.cyStyleManager == null) {
            this.cyStyleManager = this.cyGroupManager.getService(VisualMappingManager.class);
        }
        boolean lastIgnoreChanges = this.ignoreChanges;
        this.ignoreChanges = true;
        ViewUtils.styleCompoundNode(group, networkView, this.cyGroupManager, this.cyStyleManager, this.cyGroupSettings.getGroupViewType(group));
        CyEventHelper cyEventHelper = this.cyGroupManager.getService(CyEventHelper.class);
        cyEventHelper.flushPayloadEvents();
        CyGroup g = this.getGroupForNode(group.getGroupNode(), networkView);
        if (g != null && (nv = networkView.getNodeView(group.getGroupNode())) != null) {
            this.updateNodeLocation(networkView, (View<CyNode>)nv);
        }
        this.ignoreChanges = lastIgnoreChanges;
        cyEventHelper.flushPayloadEvents();
    }

    private CyGroup getGroupForNode(CyNode node, CyNetworkView networkView) {
        CyGroup group = null;
        List<CyGroup> groupList = this.cyGroupManager.getGroupsForNode(node);
        if (groupList == null || groupList.size() == 0) {
            return null;
        }
        Set<CyNode> groupNodes = this.groupMap.get(networkView);
        for (CyGroup g : groupList) {
            if (!groupNodes.contains(g.getGroupNode())) continue;
            group = g;
        }
        return group;
    }
}

