/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class DoubleListAggregator
extends AbstractAggregator<List<Double>> {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AVG, AttributeHandlingType.MIN, AttributeHandlingType.MAX, AttributeHandlingType.MEDIAN, AttributeHandlingType.SUM, AttributeHandlingType.CONCAT, AttributeHandlingType.UNIQUE};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new DoubleListAggregator(t));
            }
        }
        registered = true;
    }

    public DoubleListAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class<?> getSupportedType() {
        return List.class;
    }

    public Class<?> getSupportedListType() {
        return Double.class;
    }

    @Override
    public List<Double> aggregate(CyTable table, CyGroup group, CyColumn column) {
        Class listType = column.getListElementType();
        ArrayList<Double> agg = new ArrayList<Double>();
        ArrayList aggMed = new ArrayList();
        HashSet<Double> aggset = new HashSet<Double>();
        ArrayList<Double> aggregation = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        if (!listType.equals(Double.class)) {
            return null;
        }
        int nodeCount = 0;
        for (CyNode cyNode : group.getNodeList()) {
            List list = table.getRow((Object)cyNode.getSUID()).getList(column.getName(), listType);
            if (list == null) continue;
            int index = 0;
            ++nodeCount;
            for (Object obj : list) {
                Double value = (Double)obj;
                switch (this.type) {
                    case CONCAT: {
                        agg.add(value);
                        break;
                    }
                    case UNIQUE: {
                        aggset.add(value);
                        break;
                    }
                    case AVG: 
                    case SUM: {
                        if (agg.size() > index) {
                            value = value + (Double)agg.get(index);
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MIN: {
                        if (agg.size() > index) {
                            value = Math.min(value, (Double)agg.get(index));
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MAX: {
                        if (agg.size() > index) {
                            value = Math.max(value, (Double)agg.get(index));
                            agg.set(index, value);
                            break;
                        }
                        agg.add(index, value);
                        break;
                    }
                    case MEDIAN: {
                        if (aggMed.size() > index) {
                            ((List)aggMed.get(index)).add(value);
                            break;
                        }
                        ArrayList<Double> l = new ArrayList<Double>();
                        l.add(value);
                        aggMed.add(index, l);
                    }
                }
                ++index;
            }
        }
        if (this.type == AttributeHandlingType.UNIQUE) {
            aggregation = new ArrayList<Double>(aggset);
        } else if (this.type == AttributeHandlingType.AVG) {
            aggregation = new ArrayList();
            for (Double d : agg) {
                aggregation.add(d / (double)nodeCount);
            }
        } else if (this.type == AttributeHandlingType.MEDIAN) {
            aggregation = new ArrayList();
            for (List list : aggMed) {
                Object[] vArray = new Double[list.size()];
                vArray = list.toArray(vArray);
                Arrays.sort(vArray);
                if (vArray.length % 2 == 1) {
                    aggregation.add((Double)vArray[(vArray.length - 1) / 2]);
                    continue;
                }
                aggregation.add(((Double)vArray[vArray.length / 2 - 1] + (Double)vArray[vArray.length / 2]) / 2.0);
            }
        } else {
            aggregation = agg;
        }
        if (aggregation != null) {
            table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), aggregation);
        }
        return aggregation;
    }
}

