/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import java.util.Map;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupAggregationSettings;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.group.internal.data.CyGroupViewSettings;
import org.cytoscape.model.CyColumn;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;

public class CyGroupSettingsTask
extends AbstractTask {
    final CyGroupAggregationManager cyAggManager;
    final CyGroupManagerImpl groupMgr;
    final CyGroupSettingsImpl settings;
    CyGroup group = null;
    @ContainsTunables
    public CyGroupViewSettings viewSettings;
    @ContainsTunables
    public CyGroupAggregationSettings aggregationSettings;

    public CyGroupSettingsTask(CyGroupManagerImpl groupMgr, CyGroupAggregationManager aggMgr, CyGroupSettingsImpl settings, CyGroup group) {
        this.cyAggManager = aggMgr;
        this.groupMgr = groupMgr;
        this.settings = settings;
        this.group = group;
        this.viewSettings = new CyGroupViewSettings(settings, group);
        this.aggregationSettings = new CyGroupAggregationSettings(groupMgr, aggMgr, settings, group);
    }

    public void run(TaskMonitor taskMonitor) {
        Aggregator<?> a;
        this.settings.setDoubleClickAction(this.group, this.viewSettings.getDoubleClickAction());
        this.settings.setUseNestedNetworks(this.group, this.viewSettings.useNestedNetworks());
        this.settings.setGroupViewType(this.group, this.viewSettings.getGroupViewType());
        boolean enabled = this.aggregationSettings.getAttributeAggregationEnabled();
        this.settings.setEnableAttributeAggregation(this.group, enabled);
        if (!enabled) {
            return;
        }
        for (Class c : this.cyAggManager.getSupportedClasses()) {
            a = this.aggregationSettings.getDefaultAggregator(c);
            if (this.group != null) {
                this.settings.setDefaultAggregation(this.group, c, a);
                continue;
            }
            this.settings.setDefaultAggregation(c, a);
        }
        for (Class c : this.cyAggManager.getSupportedListClasses()) {
            a = this.aggregationSettings.getDefaultListAggregator(c);
            if (this.group != null) {
                this.settings.setDefaultListAggregation(this.group, c, a);
                continue;
            }
            this.settings.setDefaultListAggregation(c, a);
        }
        Map<CyColumn, Aggregator<?>> overrides = this.aggregationSettings.getOverrideMap();
        for (CyColumn column : overrides.keySet()) {
            if (this.group != null) {
                this.settings.setOverrideAggregation(this.group, column, overrides.get(column));
                continue;
            }
            this.settings.setOverrideAggregation(column, overrides.get(column));
        }
    }

    @ProvidesTitle
    public String getTitle() {
        return "Group Preferences";
    }
}

