/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class SConvNode
extends AbstractNode {
    private final TreeNode convertee;

    public SConvNode(TreeNode convertee) {
        super(-1);
        if (convertee == null) {
            throw new IllegalArgumentException("convertee must not be null.");
        }
        Class type = convertee.getType();
        if (type != Double.class && type != Long.class && type != Boolean.class) {
            throw new IllegalArgumentException("convertee must be of type Double, Long, or Boolean.");
        }
        this.convertee = convertee;
    }

    public String toString() {
        return "SConvNode: convertee = " + this.convertee;
    }

    public Class getType() {
        return String.class;
    }

    public TreeNode getLeftChild() {
        return this.convertee;
    }

    public TreeNode getRightChild() {
        return null;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.convertee.genCode(codeStack);
        Class type = this.convertee.getType();
        if (type == Double.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVF, this.getSourceLocation()));
        } else if (type == Long.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVI, this.getSourceLocation()));
        } else if (type == Boolean.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONVB, this.getSourceLocation()));
        } else {
            throw new IllegalStateException("unknown type: " + type + ".");
        }
    }
}

