/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;

public class Value
extends AbstractFunction {
    public Value() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.ANY, "text_or_number", "A number or a string representing a number.")});
    }

    public String getName() {
        return "VALUE";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Converts a string to a number.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        if (args[0] instanceof Number) {
            return ((Number)args[0]).doubleValue();
        }
        if (args[0] instanceof Boolean) {
            return (Boolean)args[0] != false ? 1.0 : 0.0;
        }
        if (args[0] instanceof List) {
            throw new IllegalArgumentException("List argument to VALUE() cannot be converted to a number.");
        }
        try {
            return Double.parseDouble((String)args[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("text argument \"" + args[0] + "\"of VALUE() function is not a valid number.");
        }
    }
}

