/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Tanh
extends AbstractFunction {
    public Tanh() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "Any real number representing an angle in radians.")});
    }

    public String getName() {
        return "TANH";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the hyperbolic tangent an angle given in radians.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double angleInRadians;
        try {
            angleInRadians = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to an angle in radians in a call to TANH().");
        }
        return Math.sinh(angleInRadians) / Math.cosh(angleInRadians);
    }
}

