/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Sqrt
extends AbstractFunction {
    public Sqrt() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "radicand", "A non-negative number.")});
    }

    public String getName() {
        return "SQRT";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Calculates the principal square root of a non-negative number.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws ArithmeticException {
        double number;
        try {
            number = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a number in a call to SQRT().");
        }
        if (number < 0.0) {
            throw new ArithmeticException("negative argument in call to the SQRT() function.");
        }
        return Math.sqrt(number);
    }
}

