/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Product
extends AbstractFunction {
    public Product() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_FLOATS, "numbers", "One or more numbers or lists of numbers.")});
    }

    public String getName() {
        return "PRODUCT";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the product the given numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a number in a call to PRODUCT().");
        }
        double product = 1.0;
        for (double d : numbers) {
            product *= d;
        }
        return product;
    }
}

