/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Mod
extends AbstractFunction {
    public Mod() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "The argument."), new ArgDescriptor(ArgType.FLOAT, "divisor", "A non-zero number.")});
    }

    public String getName() {
        return "MOD";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Calculates the remainder of division.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double divisor;
        double number;
        try {
            number = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a number in a call to MOD().");
        }
        try {
            divisor = FunctionUtil.getArgAsDouble((Object)args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to a divisor in a call to MOD().");
        }
        if (divisor == 0.0) {
            throw new ArithmeticException("division by zero in call to MOD().");
        }
        double result = number % divisor;
        if (Math.signum(result) != Math.signum(divisor)) {
            return -result;
        }
        return result;
    }
}

