/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Log
extends AbstractFunction {
    public Log() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "argument", "A positive number."), new ArgDescriptor(ArgType.OPT_FLOAT, "base", "A positive number.")});
    }

    public String getName() {
        return "LOG";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the logarithm of a number to a specified base.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double base;
        double number;
        try {
            number = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a number in a call to LOG().");
        }
        if (args.length == 1) {
            base = 10.0;
        } else {
            try {
                base = FunctionUtil.getArgAsDouble((Object)args[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to a base in a call to LOG().");
            }
        }
        if (number <= 0.0) {
            throw new IllegalArgumentException("LOG() called with a number <= 0.0.");
        }
        if (base <= 0.0) {
            throw new IllegalArgumentException("LOG() called with a base <= 0.0.");
        }
        double retval = Math.log10(number);
        if (base != 10.0) {
            retval /= Math.log10(base);
        }
        return retval;
    }
}

