/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.internal.DoubleList;

public class FList
extends AbstractFunction {
    public FList() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_FLOATS, "numbers", "Zero or more numbers, strings or booleans.")});
    }

    public String getName() {
        return "FLIST";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns a list of floating point numbers.";
    }

    public Class<?> getReturnType() {
        return DoubleList.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a number in a call to FLIST().");
        }
        return new DoubleList(numbers);
    }
}

