/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.sync;

import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingTaskMonitor
implements TaskMonitor {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String LOG_PREFIX = "TaskMonitor";
    private Logger messageLogger = LoggerFactory.getLogger((String)"TaskMonitor");
    private Task task;

    public void setTask(Task newTask) {
        this.task = newTask;
        this.messageLogger = LoggerFactory.getLogger((String)("TaskMonitor." + newTask.getClass().getName()));
    }

    public void setTitle(String title) {
        logger.info("Task (" + this.task.toString() + ") title: " + title);
    }

    public void setStatusMessage(String statusMessage) {
        this.showMessage(TaskMonitor.Level.INFO, statusMessage);
    }

    public void showMessage(TaskMonitor.Level level, String message, int wait) {
        this.showMessage(level, message);
    }

    public void showMessage(TaskMonitor.Level level, String message) {
        switch (level) {
            case INFO: {
                logger.info("Task (" + this.task.toString() + ") status: " + message);
                this.messageLogger.info(message);
                break;
            }
            case WARN: {
                logger.warn("Task (" + this.task.toString() + ") status: " + message);
                this.messageLogger.warn(message);
                break;
            }
            case ERROR: {
                logger.error("Task (" + this.task.toString() + ") status: " + message);
                this.messageLogger.error(message);
            }
        }
    }

    public void setProgress(double progress) {
        int prog = (int)Math.floor(progress * 100.0);
        logger.info("Task (" + this.task.toString() + ") progress: " + prog + "%");
    }

    public void showException(Exception exception) {
        logger.error("Exception executing task: " + exception.getMessage(), (Throwable)exception);
        this.messageLogger.error("Error executing task: " + exception.getMessage(), (Throwable)exception);
    }
}

