/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.sync;

import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

class DelegatingTaskMonitor
implements TaskMonitor {
    private double expectedNumTasks;
    private double currentTaskNum = -1.0;
    private TaskMonitor actualTaskMonitor;
    private double fractionOfOverall = 1.0;

    DelegatingTaskMonitor(TaskMonitor tm, int expectedNumTasks) {
        this.actualTaskMonitor = tm;
        this.expectedNumTasks = expectedNumTasks;
        this.fractionOfOverall = 1.0 / this.expectedNumTasks;
    }

    public void setTask(Task newTask) {
        this.currentTaskNum += 1.0;
    }

    public void setTitle(String title) {
        this.actualTaskMonitor.setTitle(title);
    }

    public void setStatusMessage(String statusMessage) {
        this.actualTaskMonitor.setStatusMessage(statusMessage);
    }

    public void showMessage(TaskMonitor.Level level, String message, int wait) {
        this.actualTaskMonitor.showMessage(level, message, wait);
    }

    public void showMessage(TaskMonitor.Level level, String message) {
        this.actualTaskMonitor.showMessage(level, message);
    }

    public void setProgress(double progress) {
        if (progress < 0.0) {
            this.actualTaskMonitor.setProgress(-1.0);
        } else {
            double completed = this.currentTaskNum / this.expectedNumTasks;
            double adjustedProgress = progress * this.fractionOfOverall + completed;
            this.actualTaskMonitor.setProgress(adjustedProgress);
        }
    }
}

