/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.properties.TunablePropertyHandler;

public class BasicTypePropertyHandler
extends AbstractTunableHandler
implements TunablePropertyHandler {
    public BasicTypePropertyHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
    }

    public BasicTypePropertyHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
    }

    public static Class<?>[] supportedTypes() {
        return new Class[]{Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Byte.class, Byte.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, String.class, Enum.class};
    }

    public String toPropertyValue() {
        try {
            return BasicTypePropertyHandler.toPropertyValue(this.getValue());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not get value", e);
        }
    }

    static String toPropertyValue(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value == null ? "null" : value.toString();
    }

    public void parseAndSetValue(String propertyValue) {
        Object value = BasicTypePropertyHandler.parseValue(this.getName(), propertyValue, this.getType());
        try {
            this.setValue(value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Object parseValue(String propertyName, String propertyValue, Class<?> type) {
        if (propertyValue == null || "null".equals(propertyValue)) {
            return null;
        }
        if (type == String.class) {
            return propertyValue;
        }
        if (type.isPrimitive()) {
            type = BasicTypePropertyHandler.primitiveToWrapper(type);
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf != null && Modifier.isStatic(valueOf.getModifiers())) {
                return valueOf.invoke(null, propertyValue);
            }
            throw new IllegalArgumentException("Can't find valueOf() method in type: " + type);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can't parse property value '" + propertyName + "'", e);
        }
    }

    private static Class<?> primitiveToWrapper(Class<?> c) {
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException("Class must be primitive: " + c);
    }
}

