/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.InputStream;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.psi_mi.internal.plugin.PsiMiTabParser;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class PsiMiTabReader
extends AbstractCyNetworkReader {
    private final CyLayoutAlgorithmManager layouts;
    private final PsiMiTabParser parser;
    private TaskMonitor parentTaskMonitor;

    public PsiMiTabReader(InputStream is, CyApplicationManager applicationManager, CyNetworkViewFactory networkViewFactory, CyNetworkFactory networkFactory, CyLayoutAlgorithmManager layouts, CyNetworkManager networkManager, CyRootNetworkManager rootNetworkManager) {
        super(is, applicationManager, networkFactory, networkManager, rootNetworkManager);
        this.layouts = layouts;
        this.parser = new PsiMiTabParser(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        this.parentTaskMonitor = taskMonitor;
        CyRootNetwork rootNetwork = this.getRootNetwork();
        CySubNetwork newNetwork = rootNetwork != null ? rootNetwork.addSubNetwork() : (CySubNetwork)this.cyNetworkFactory.createNetwork();
        this.parser.setNodeMap(this.getNodeMap());
        try {
            taskMonitor.setTitle("Loading PSIMI-TAB File");
            taskMonitor.setStatusMessage("Loading PSI-MI-TAB25 file.");
            taskMonitor.setProgress(0.01);
            this.parser.parse(newNetwork, taskMonitor);
            this.networks = new CyNetwork[]{newNetwork};
            taskMonitor.setProgress(1.0);
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        if (this.cancelled) {
            if (network != null) {
                network.dispose();
                network = null;
            }
            throw new RuntimeException("Network loading canceled by user.");
        }
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        CyLayoutAlgorithm layout = this.layouts.getDefaultLayout();
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, "");
        Task nextTask = itr.next();
        try {
            nextTask.run(this.parentTaskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        return view;
    }

    public void cancel() {
        super.cancel();
        this.parser.cancel();
    }
}

