/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.psi_mi.internal.plugin.MITABLine25;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsiMiTabParser {
    private static final Logger logger = LoggerFactory.getLogger(PsiMiTabParser.class);
    private static final int BUFFER_SIZE = 100000;
    private static final String ATTR_PREFIX = "PSIMI-25.";
    private static final String INTERACTOR_TYPE = "PSIMI-25.interactor type";
    private static final String ALIASES = "PSIMI-25.aliases";
    private static final String TAXONIDS = "PSIMI-25.taxon ID";
    private static final String TAXONDBS = "PSIMI-25.taxon DB";
    private static final String INTERACTION = "interaction";
    private static final String DETECTION_METHOD_ID = "PSIMI-25.detection method ID";
    private static final String DETECTION_METHOD = "PSIMI-25.detection method";
    private static final String INTERACTION_TYPE = "PSIMI-25.interaction type";
    private static final String INTERACTION_TYPE_ID = "PSIMI-25.interaction type ID";
    private static final String SOURCE_DB = "PSIMI-25.source DB";
    private static final String EDGE_SCORE = "PSIMI-25.edge score";
    private static final String AUTHORS = "PSIMI-25.authors";
    private static final String PUBLICATION_ID = "PSIMI-25.publication ID";
    private static final String PUBLICATION_DB = "PSIMI-25.publication DB";
    private static final String CHEBI = "chebi";
    private static final String COMPOUND = "compound";
    private final InputStream inputStream;
    private Map<Object, CyNode> nMap;
    private volatile boolean cancelFlag;

    public PsiMiTabParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void parse(CySubNetwork network, TaskMonitor taskMonitor) throws IOException {
        taskMonitor.setProgress(-1.0);
        this.initColumns((CyNetwork)network);
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, Charset.forName("UTF-8").newDecoder()), 100000);
        MITABLine25 mline = new MITABLine25();
        long interactionCount = 0L;
        while ((line = br.readLine()) != null) {
            if (this.cancelFlag) {
                System.out.println("Loading canceld.");
                br.close();
                network.dispose();
                throw new IOException("Network loading process canceled by user.");
            }
            if (line.startsWith("#")) continue;
            try {
                this.processFull(network, mline, line);
            }
            catch (Exception ex) {
                logger.warn("Could not parse this line: " + line, (Throwable)ex);
                continue;
            }
            if (++interactionCount % 1000L != 0L) continue;
            taskMonitor.setStatusMessage("parsed " + interactionCount + " interactions");
        }
        br.close();
    }

    private void processFull(CySubNetwork network, MITABLine25 mline, String line) {
        CyNode target;
        CyNode source;
        mline.readLine(line);
        String primaryKeyName = mline.srcDBs.get(0);
        if (network.getDefaultNodeTable().getColumn(primaryKeyName) == null) {
            network.getDefaultNodeTable().createColumn(primaryKeyName, String.class, true);
        }
        String sourceRawID = mline.sourceRawID;
        String targetRawID = mline.targetRawID;
        CyRootNetwork rootNetwork = network.getRootNetwork();
        if (this.nMap.get(sourceRawID) == null) {
            source = network.addNode();
            this.nMap.put(sourceRawID, rootNetwork.getNode(source.getSUID().longValue()));
        } else {
            CyNode parentNode = this.nMap.get(sourceRawID);
            CySubNetwork subnet = network;
            subnet.addNode(parentNode);
            source = subnet.getNode(parentNode.getSUID().longValue());
        }
        if (this.nMap.get(targetRawID) == null) {
            target = network.addNode();
            this.nMap.put(targetRawID, rootNetwork.getNode(target.getSUID().longValue()));
        } else {
            CyNode parentNode = this.nMap.get(targetRawID);
            CySubNetwork subnet = network;
            subnet.addNode(parentNode);
            target = subnet.getNode(parentNode.getSUID().longValue());
        }
        CyRow sourceRow = network.getRow((CyIdentifiable)source);
        CyRow targetRow = network.getRow((CyIdentifiable)target);
        sourceRow.set("name", (Object)sourceRawID);
        targetRow.set("name", (Object)targetRawID);
        sourceRow.set(primaryKeyName, (Object)sourceRawID);
        targetRow.set(primaryKeyName, (Object)targetRawID);
        List<String> sDB = mline.sourceDBs;
        for (int i = 0; i < sDB.size(); ++i) {
            String dbName = sDB.get(i);
            if (sourceRow.getTable().getColumn(dbName) == null) {
                sourceRow.getTable().createColumn(dbName, String.class, true);
            }
            sourceRow.set(dbName, (Object)mline.sourceIDs.get(i));
        }
        this.setInteractorType(sourceRow, mline.srcAliases);
        this.setInteractorType(targetRow, mline.tgtAliases);
        this.setAliases(sourceRow, mline.srcAliases, mline.srcDBs);
        this.setAliases(targetRow, mline.tgtAliases, mline.tgtDBs);
        this.setTaxID(sourceRow, mline.srcTaxonIDs, mline.srcTaxonDBs);
        this.setTaxID(targetRow, mline.tgtTaxonIDs, mline.tgtTaxonDBs);
        CyEdge e = network.addEdge(source, target, true);
        CyRow edgeRow = network.getRow((CyIdentifiable)e);
        String interactionId = "unknown";
        if (mline.interactionIDs.size() > 0) {
            interactionId = mline.interactionIDs.get(0);
        }
        edgeRow.set(INTERACTION, (Object)interactionId);
        edgeRow.set("name", (Object)(sourceRawID + " (" + interactionId + ") " + targetRawID));
        this.setTypedEdgeListAttribute(edgeRow, mline.interactionTypes, INTERACTION_TYPE_ID, INTERACTION_TYPE);
        this.setTypedEdgeListAttribute(edgeRow, mline.detectionMethods, DETECTION_METHOD_ID, DETECTION_METHOD);
        this.setEdgeListAttribute(edgeRow, mline.sourceDBs, SOURCE_DB);
        this.setEdgeListAttribute(edgeRow, mline.edgeScoreStrings, EDGE_SCORE);
        this.setPublication(edgeRow, mline.publicationValues, mline.publicationDBs);
        this.setAuthors(edgeRow, mline.authors);
    }

    private void setTaxID(CyRow row, List<String> taxonIDs, List<String> taxonDBs) {
        row.set(TAXONIDS, taxonIDs);
        row.set(TAXONDBS, taxonDBs);
    }

    private void setPublication(CyRow row, List<String> pubID, List<String> pubDB) {
        for (int i = 0; i < pubID.size(); ++i) {
            this.listAttrMapper(row, PUBLICATION_ID, pubID.get(i));
            this.listAttrMapper(row, PUBLICATION_DB, pubDB.get(i));
        }
    }

    private void setAuthors(CyRow row, List<String> authors) {
        for (String val : authors) {
            this.listAttrMapper(row, AUTHORS, val);
        }
    }

    private void setAliases(CyRow row, List<String> aliases, List<String> aliasDBs) {
        for (String s : aliases) {
            int ind = s.indexOf(40);
            if (ind > 0) {
                s = s.substring(0, ind);
            }
            this.listAttrMapper(row, ALIASES, s);
        }
    }

    private void setEdgeListAttribute(CyRow row, List<String> entry, String key) {
        for (String val : entry) {
            this.listAttrMapper(row, key, val);
        }
    }

    private void setTypedEdgeListAttribute(CyRow row, List<String> entry, String idKey, String descKey) {
        for (String val : entry) {
            int secondQuote;
            int firstQuote;
            int closeParen;
            String id = "";
            String desc = "";
            int openParen = val.indexOf(40);
            if (openParen >= 0 && (closeParen = val.indexOf(41)) > openParen) {
                desc = val.substring(openParen + 1, closeParen);
            }
            if ((firstQuote = val.indexOf(34)) >= 0 && (secondQuote = val.indexOf(34, firstQuote + 1)) > firstQuote) {
                id = val.substring(firstQuote + 1, secondQuote);
            }
            if (desc.equals("") || id.equals("")) {
                this.listAttrMapper(row, descKey, val);
                continue;
            }
            this.listAttrMapper(row, idKey, id);
            this.listAttrMapper(row, descKey, desc);
        }
    }

    private void listAttrMapper(CyRow row, String attrName, String value) {
        ArrayList<String> currentAttr = row.getList(attrName, String.class);
        if (currentAttr == null) {
            currentAttr = new ArrayList<String>();
            currentAttr.add(value);
            row.set(attrName, currentAttr);
        } else if (!currentAttr.contains(value)) {
            currentAttr.add(value);
            row.set(attrName, currentAttr);
        }
    }

    void cancel() {
        this.cancelFlag = true;
    }

    private void setInteractorType(CyRow row, List<String> aliases) {
        if (aliases.contains(CHEBI)) {
            row.set(INTERACTOR_TYPE, (Object)COMPOUND);
        }
    }

    private void initColumns(CyNetwork network) {
        CyTable nodeTable = network.getDefaultNodeTable();
        this.createListColumn(nodeTable, INTERACTOR_TYPE, String.class);
        this.createListColumn(nodeTable, ALIASES, String.class);
        this.createListColumn(nodeTable, TAXONIDS, String.class);
        this.createListColumn(nodeTable, TAXONDBS, String.class);
        CyTable edgeTable = network.getDefaultEdgeTable();
        this.createListColumn(edgeTable, INTERACTION_TYPE, String.class);
        this.createListColumn(edgeTable, INTERACTION_TYPE_ID, String.class);
        this.createListColumn(edgeTable, DETECTION_METHOD, String.class);
        this.createListColumn(edgeTable, DETECTION_METHOD_ID, String.class);
        this.createListColumn(edgeTable, SOURCE_DB, String.class);
        this.createListColumn(edgeTable, EDGE_SCORE, String.class);
        this.createListColumn(edgeTable, AUTHORS, String.class);
        this.createListColumn(edgeTable, PUBLICATION_ID, String.class);
        this.createListColumn(edgeTable, PUBLICATION_DB, String.class);
    }

    private void createListColumn(CyTable table, String colName, Class<?> type) {
        if (table.getColumn(colName) == null) {
            table.createListColumn(colName, String.class, false);
        }
    }

    public void setNodeMap(Map<Object, CyNode> nMap) {
        this.nMap = nMap;
    }
}

