/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.io.InputStream;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.read.AbstractInputStreamTaskFactory;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.psi_mi.internal.plugin.PSIMI10XMLNetworkViewReader;
import org.cytoscape.psi_mi.internal.plugin.PSIMI25XMLNetworkViewReader;
import org.cytoscape.psi_mi.internal.plugin.PsiMiCyFileFilter;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class PsiMiNetworkViewTaskFactory
extends AbstractInputStreamTaskFactory {
    private final CyApplicationManager cyApplicationManager;
    private final CyNetworkViewFactory networkViewFactory;
    private final CyNetworkFactory networkFactory;
    private final CyLayoutAlgorithmManager layouts;
    private final CyNetworkManager cyNetworkManager;
    private final CyRootNetworkManager cyRootNetworkManager;
    private final PsiMiCyFileFilter.PSIMIVersion version;

    public PsiMiNetworkViewTaskFactory(PsiMiCyFileFilter.PSIMIVersion version, CyFileFilter filter, CyApplicationManager cyApplicationManager, CyNetworkFactory networkFactory, CyNetworkViewFactory networkViewFactory, CyLayoutAlgorithmManager layouts, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager) {
        super(filter);
        this.cyApplicationManager = cyApplicationManager;
        this.networkFactory = networkFactory;
        this.networkViewFactory = networkViewFactory;
        this.layouts = layouts;
        this.version = version;
        this.cyNetworkManager = cyNetworkManager;
        this.cyRootNetworkManager = cyRootNetworkManager;
    }

    public TaskIterator createTaskIterator(InputStream inputStream, String inputName) {
        if (this.version == PsiMiCyFileFilter.PSIMIVersion.PSIMI25) {
            return new TaskIterator(3, new Task[]{new PSIMI25XMLNetworkViewReader(inputStream, this.cyApplicationManager, this.networkFactory, this.networkViewFactory, this.layouts, this.cyNetworkManager, this.cyRootNetworkManager)});
        }
        return new TaskIterator(3, new Task[]{new PSIMI10XMLNetworkViewReader(inputStream, this.cyApplicationManager, this.networkFactory, this.networkViewFactory, this.layouts, this.cyNetworkManager, this.cyRootNetworkManager)});
    }
}

