/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal.tunables;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.cytoscape.command.StringToModel;
import org.cytoscape.command.StringTunableHandlerFactory;
import org.cytoscape.command.internal.tunables.CyIdentifiableTunableHandler;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyIdentifiableStringTunableHandlerFactory<T extends CyIdentifiableTunableHandler>
implements StringTunableHandlerFactory<T> {
    private final StringToModel stringHandler;
    private final Class<T> tunableHandlerClass;
    private final Class<?>[] allowedTypes;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CyIdentifiableStringTunableHandlerFactory(StringToModel stringHandler, Class<T> specificHandlerType, Class<?> ... classesToMatch) {
        this.tunableHandlerClass = specificHandlerType;
        this.allowedTypes = classesToMatch;
        this.stringHandler = stringHandler;
    }

    public final T createTunableHandler(Field field, Object instance, Tunable tunable) {
        if (!this.properType(field.getType())) {
            return null;
        }
        try {
            Constructor<T> con = this.tunableHandlerClass.getConstructor(Field.class, Object.class, Tunable.class);
            CyIdentifiableTunableHandler handlerInstance = (CyIdentifiableTunableHandler)con.newInstance(field, instance, tunable);
            handlerInstance.setStringHandler(this.stringHandler);
            return (T)handlerInstance;
        }
        catch (Exception e) {
            logger.warn("Failed to construct tunable handler. Missing Field based constructor for class: " + this.tunableHandlerClass.getName(), (Throwable)e);
            return null;
        }
    }

    public final T createTunableHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        if (!this.properType(getter.getReturnType())) {
            return null;
        }
        try {
            Constructor<T> con = this.tunableHandlerClass.getConstructor(Method.class, Method.class, Object.class, Tunable.class);
            CyIdentifiableTunableHandler handlerInstance = (CyIdentifiableTunableHandler)con.newInstance(getter, setter, instance, tunable);
            handlerInstance.setStringHandler(this.stringHandler);
            return (T)handlerInstance;
        }
        catch (Exception e) {
            logger.warn("Failed to construct tunable handler. Missing Method based constructor for class: " + this.tunableHandlerClass.getName(), (Throwable)e);
            return null;
        }
    }

    private boolean properType(Class<?> c) {
        for (Class<?> allowed : this.allowedTypes) {
            if (!allowed.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }
}

