/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal.tasks;

import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SleepCommandTask
extends AbstractTask {
    @Tunable(description="Duration of sleep in seconds", longDescription="Enter the time in seconds to sleep", exampleStringValue="5")
    public double duration;

    @ProvidesTitle
    public String getTitle() {
        return "Sleeping...";
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.duration != 0.0) {
            tm.showMessage(TaskMonitor.Level.INFO, "Sleeping for " + this.duration + " seconds");
            Thread.sleep((long)this.duration * 1000L);
            tm.showMessage(TaskMonitor.Level.INFO, "Slept for " + this.duration + " seconds");
        }
    }
}

