/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.util.Map;
import org.cytoscape.command.internal.Executor;
import org.cytoscape.command.internal.tunables.CommandTunableInterceptorImpl;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TFExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final TaskFactory tf;
    private final CommandTunableInterceptorImpl interceptor;

    public TFExecutor(TaskFactory tf, CommandTunableInterceptorImpl interceptor) {
        this.tf = tf;
        this.interceptor = interceptor;
    }

    @Override
    public void execute(String args, TaskMonitor taskMonitor, TaskObserver observer) throws Exception {
        this.interceptor.setConfigurationContext((String)null);
        TaskIterator ti = this.tf.createTaskIterator();
        while (ti.hasNext()) {
            Task t = ti.next();
            this.interceptor.setConfigurationContext(args);
            this.interceptor.validateAndWriteBackTunables(t);
            LogDelegateTaskMonitor tm = new LogDelegateTaskMonitor(taskMonitor);
            if (!this.interceptor.validateTunableInput(t, tm)) {
                if (observer != null) {
                    observer.allFinished(FinishStatus.newCancelled((Task)t));
                }
                return;
            }
            t.run((TaskMonitor)tm);
            if (observer == null || !(t instanceof ObservableTask)) continue;
            observer.taskFinished((ObservableTask)t);
        }
    }

    @Override
    public void execute(Map<String, Object> args, TaskMonitor taskMonitor, TaskObserver observer) throws Exception {
        this.interceptor.setConfigurationContext((Map<String, Object>)null);
        TaskIterator ti = this.tf.createTaskIterator();
        while (ti.hasNext()) {
            Task t = ti.next();
            this.interceptor.setConfigurationContext(args);
            this.interceptor.validateAndWriteBackTunables(t);
            LogDelegateTaskMonitor tm = new LogDelegateTaskMonitor(taskMonitor);
            if (!this.interceptor.validateTunableInput(t, tm)) {
                if (observer != null) {
                    observer.allFinished(FinishStatus.newCancelled((Task)t));
                }
                return;
            }
            t.run((TaskMonitor)tm);
            if (observer == null || !(t instanceof ObservableTask)) continue;
            observer.taskFinished((ObservableTask)t);
        }
    }

    private class LogDelegateTaskMonitor
    implements TaskMonitor {
        private TaskMonitor delegate;

        public LogDelegateTaskMonitor(TaskMonitor delegate) {
            this.delegate = delegate;
        }

        public void setTitle(String title) {
        }

        public void setProgress(double progress) {
        }

        public void setStatusMessage(String statusMessage) {
            this.showMessage(TaskMonitor.Level.INFO, statusMessage);
        }

        public void showMessage(TaskMonitor.Level level, String message, int wait) {
            this.showMessage(level, message);
        }

        public void showMessage(TaskMonitor.Level level, String message) {
            switch (level) {
                case INFO: {
                    logger.info(message);
                    break;
                }
                case WARN: {
                    logger.warn(message);
                    break;
                }
                case ERROR: {
                    logger.error(message);
                }
            }
            if (this.delegate != null) {
                this.delegate.showMessage(level, message);
            }
        }
    }
}

