/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command.internal;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.command.StringToModel;
import org.cytoscape.command.StringTunableHandlerFactory;
import org.cytoscape.command.internal.CommandExecutorImpl;
import org.cytoscape.command.internal.CommandExecutorTaskFactoryImpl;
import org.cytoscape.command.internal.StringToModelImpl;
import org.cytoscape.command.internal.available.ArgHandlerFactory;
import org.cytoscape.command.internal.available.ArgRecorder;
import org.cytoscape.command.internal.available.AvailableCommandsImpl;
import org.cytoscape.command.internal.available.BasicArgHandlerFactory;
import org.cytoscape.command.internal.tasks.EchoCommandTaskFactory;
import org.cytoscape.command.internal.tasks.QuitTaskFactory;
import org.cytoscape.command.internal.tasks.RunCommandsTaskFactory;
import org.cytoscape.command.internal.tasks.SleepCommandTaskFactory;
import org.cytoscape.command.internal.tunables.BooleanTunableHandler;
import org.cytoscape.command.internal.tunables.BoundedDoubleTunableHandler;
import org.cytoscape.command.internal.tunables.BoundedFloatTunableHandler;
import org.cytoscape.command.internal.tunables.BoundedIntTunableHandler;
import org.cytoscape.command.internal.tunables.BoundedLongTunableHandler;
import org.cytoscape.command.internal.tunables.CharTunableHandlerImpl;
import org.cytoscape.command.internal.tunables.CommandTunableInterceptorImpl;
import org.cytoscape.command.internal.tunables.CyIdentifiableStringTunableHandlerFactory;
import org.cytoscape.command.internal.tunables.CyNetworkTunableHandler;
import org.cytoscape.command.internal.tunables.CyNetworkViewTunableHandler;
import org.cytoscape.command.internal.tunables.CyTableTunableHandler;
import org.cytoscape.command.internal.tunables.DoubleTunableHandler;
import org.cytoscape.command.internal.tunables.EdgeListTunableHandler;
import org.cytoscape.command.internal.tunables.FileTunableHandler;
import org.cytoscape.command.internal.tunables.FloatTunableHandler;
import org.cytoscape.command.internal.tunables.IntTunableHandler;
import org.cytoscape.command.internal.tunables.ListMultipleTunableHandler;
import org.cytoscape.command.internal.tunables.ListSingleTunableHandler;
import org.cytoscape.command.internal.tunables.LongTunableHandler;
import org.cytoscape.command.internal.tunables.NodeListTunableHandler;
import org.cytoscape.command.internal.tunables.RowListTunableHandler;
import org.cytoscape.command.internal.tunables.SimpleStringTunableHandlerFactory;
import org.cytoscape.command.internal.tunables.StringTunableHandlerImpl;
import org.cytoscape.command.internal.tunables.URLTunableHandler;
import org.cytoscape.command.util.EdgeList;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.command.util.RowList;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.BoundedFloat;
import org.cytoscape.work.util.BoundedInteger;
import org.cytoscape.work.util.BoundedLong;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    public void start(final BundleContext bc) {
        final CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CommandTunableInterceptorImpl interceptor = new CommandTunableInterceptorImpl(serviceRegistrar);
        SimpleStringTunableHandlerFactory<FileTunableHandler> fileTHF = new SimpleStringTunableHandlerFactory<FileTunableHandler>(FileTunableHandler.class, File.class);
        SimpleStringTunableHandlerFactory<IntTunableHandler> intTHF = new SimpleStringTunableHandlerFactory<IntTunableHandler>(IntTunableHandler.class, Integer.class, Integer.TYPE);
        SimpleStringTunableHandlerFactory<DoubleTunableHandler> doubleTHF = new SimpleStringTunableHandlerFactory<DoubleTunableHandler>(DoubleTunableHandler.class, Double.class, Double.TYPE);
        SimpleStringTunableHandlerFactory<FloatTunableHandler> floatTHF = new SimpleStringTunableHandlerFactory<FloatTunableHandler>(FloatTunableHandler.class, Float.class, Float.TYPE);
        SimpleStringTunableHandlerFactory<LongTunableHandler> longTHF = new SimpleStringTunableHandlerFactory<LongTunableHandler>(LongTunableHandler.class, Long.class, Long.TYPE);
        SimpleStringTunableHandlerFactory<BooleanTunableHandler> booleanTHF = new SimpleStringTunableHandlerFactory<BooleanTunableHandler>(BooleanTunableHandler.class, Boolean.class, Boolean.TYPE);
        SimpleStringTunableHandlerFactory<StringTunableHandlerImpl> stringTHF = new SimpleStringTunableHandlerFactory<StringTunableHandlerImpl>(StringTunableHandlerImpl.class, String.class);
        SimpleStringTunableHandlerFactory<CharTunableHandlerImpl> charTHF = new SimpleStringTunableHandlerFactory<CharTunableHandlerImpl>(CharTunableHandlerImpl.class, Character.class, Character.TYPE);
        SimpleStringTunableHandlerFactory<BoundedIntTunableHandler> boundedIntTHF = new SimpleStringTunableHandlerFactory<BoundedIntTunableHandler>(BoundedIntTunableHandler.class, BoundedInteger.class);
        SimpleStringTunableHandlerFactory<BoundedDoubleTunableHandler> boundedDoubleTHF = new SimpleStringTunableHandlerFactory<BoundedDoubleTunableHandler>(BoundedDoubleTunableHandler.class, BoundedDouble.class);
        SimpleStringTunableHandlerFactory<BoundedFloatTunableHandler> boundedFloatTHF = new SimpleStringTunableHandlerFactory<BoundedFloatTunableHandler>(BoundedFloatTunableHandler.class, BoundedFloat.class);
        SimpleStringTunableHandlerFactory<BoundedLongTunableHandler> boundedLongTHF = new SimpleStringTunableHandlerFactory<BoundedLongTunableHandler>(BoundedLongTunableHandler.class, BoundedLong.class);
        SimpleStringTunableHandlerFactory<URLTunableHandler> urlTHF = new SimpleStringTunableHandlerFactory<URLTunableHandler>(URLTunableHandler.class, URL.class);
        SimpleStringTunableHandlerFactory<ListSingleTunableHandler> listSingleTHF = new SimpleStringTunableHandlerFactory<ListSingleTunableHandler>(ListSingleTunableHandler.class, ListSingleSelection.class);
        SimpleStringTunableHandlerFactory<ListMultipleTunableHandler> listMultipleTHF = new SimpleStringTunableHandlerFactory<ListMultipleTunableHandler>(ListMultipleTunableHandler.class, ListMultipleSelection.class);
        this.registerService(bc, fileTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, intTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, doubleTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, floatTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, longTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, booleanTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, stringTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, charTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, boundedIntTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, boundedDoubleTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, boundedFloatTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, boundedLongTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, urlTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, listSingleTHF, StringTunableHandlerFactory.class, new Properties());
        this.registerService(bc, listMultipleTHF, StringTunableHandlerFactory.class, new Properties());
        StringToModelImpl stm = new StringToModelImpl(serviceRegistrar);
        this.registerService(bc, stm, StringToModel.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<CyNetworkTunableHandler> networkTHF = new CyIdentifiableStringTunableHandlerFactory<CyNetworkTunableHandler>(stm, CyNetworkTunableHandler.class, CyNetwork.class);
        this.registerService(bc, networkTHF, StringTunableHandlerFactory.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<CyNetworkViewTunableHandler> networkViewTHF = new CyIdentifiableStringTunableHandlerFactory<CyNetworkViewTunableHandler>(stm, CyNetworkViewTunableHandler.class, CyNetworkView.class);
        this.registerService(bc, networkViewTHF, StringTunableHandlerFactory.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<CyTableTunableHandler> tableTHF = new CyIdentifiableStringTunableHandlerFactory<CyTableTunableHandler>(stm, CyTableTunableHandler.class, CyTable.class);
        this.registerService(bc, tableTHF, StringTunableHandlerFactory.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<NodeListTunableHandler> nodeListTHF = new CyIdentifiableStringTunableHandlerFactory<NodeListTunableHandler>(stm, NodeListTunableHandler.class, NodeList.class);
        this.registerService(bc, nodeListTHF, StringTunableHandlerFactory.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<EdgeListTunableHandler> edgeListTHF = new CyIdentifiableStringTunableHandlerFactory<EdgeListTunableHandler>(stm, EdgeListTunableHandler.class, EdgeList.class);
        this.registerService(bc, edgeListTHF, StringTunableHandlerFactory.class, new Properties());
        CyIdentifiableStringTunableHandlerFactory<RowListTunableHandler> rowListTHF = new CyIdentifiableStringTunableHandlerFactory<RowListTunableHandler>(stm, RowListTunableHandler.class, RowList.class);
        this.registerService(bc, rowListTHF, StringTunableHandlerFactory.class, new Properties());
        BasicArgHandlerFactory argHandlerFactory = new BasicArgHandlerFactory();
        this.registerService(bc, argHandlerFactory, ArgHandlerFactory.class, new Properties());
        ArgRecorder argRec = new ArgRecorder();
        this.registerServiceListener(bc, argRec::addTunableHandlerFactory, argRec::removeTunableHandlerFactory, ArgHandlerFactory.class);
        AvailableCommandsImpl availableCommandsImpl = new AvailableCommandsImpl(argRec, serviceRegistrar);
        this.registerService(bc, availableCommandsImpl, AvailableCommands.class, new Properties());
        this.registerServiceListener(bc, availableCommandsImpl::addTaskFactory, availableCommandsImpl::removeTaskFactory, TaskFactory.class);
        this.registerServiceListener(bc, availableCommandsImpl::addNetworkTaskFactory, availableCommandsImpl::removeNetworkTaskFactory, NetworkTaskFactory.class);
        this.registerServiceListener(bc, availableCommandsImpl::addNetworkViewTaskFactory, availableCommandsImpl::removeNetworkViewTaskFactory, NetworkViewTaskFactory.class);
        this.registerServiceListener(bc, availableCommandsImpl::addNetworkViewCollectionTaskFactory, availableCommandsImpl::removeNetworkViewCollectionTaskFactory, NetworkViewCollectionTaskFactory.class);
        this.registerServiceListener(bc, availableCommandsImpl::addTableTaskFactory, availableCommandsImpl::removeTableTaskFactory, TableTaskFactory.class);
        CommandExecutorImpl commandExecutor = new CommandExecutorImpl(interceptor, availableCommandsImpl, serviceRegistrar);
        final CommandExecutorTaskFactoryImpl commandExecutorTaskFactory = new CommandExecutorTaskFactoryImpl(commandExecutor, serviceRegistrar);
        Properties commandExecutorTaskFactoryProps = new Properties();
        commandExecutorTaskFactoryProps.setProperty("id", "commandExecutorTaskFactory");
        this.registerService(bc, (Object)commandExecutorTaskFactory, TaskFactory.class, commandExecutorTaskFactoryProps);
        this.registerService(bc, (Object)commandExecutorTaskFactory, CommandExecutorTaskFactory.class, commandExecutorTaskFactoryProps);
        this.registerServiceListener(bc, commandExecutor::addTaskFactory, commandExecutor::removeTaskFactory, TaskFactory.class);
        this.registerServiceListener(bc, commandExecutor::addNetworkTaskFactory, commandExecutor::removeNetworkTaskFactory, NetworkTaskFactory.class);
        this.registerServiceListener(bc, commandExecutor::addNetworkViewTaskFactory, commandExecutor::removeNetworkViewTaskFactory, NetworkViewTaskFactory.class);
        this.registerServiceListener(bc, commandExecutor::addNetworkViewCollectionTaskFactory, commandExecutor::removeNetworkViewCollectionTaskFactory, NetworkViewCollectionTaskFactory.class);
        this.registerServiceListener(bc, commandExecutor::addTableTaskFactory, commandExecutor::removeTableTaskFactory, TableTaskFactory.class);
        this.registerServiceListener(bc, interceptor::addTunableHandlerFactory, interceptor::removeTunableHandlerFactory, StringTunableHandlerFactory.class);
        Properties props = new Properties();
        props.setProperty("command", "sleep");
        props.setProperty("commandNamespace", "command");
        props.setProperty("commandDescription", "Stop command processing for a specified time");
        props.setProperty("commandLongDescription", "The **sleep** command will pause processing for a period of time as specified by *duration* seconds.");
        this.registerService(bc, (Object)new SleepCommandTaskFactory(), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "echo");
        props.setProperty("commandNamespace", "command");
        props.setProperty("commandDescription", "Returns the value of the 'message' argument.");
        props.setProperty("commandLongDescription", "Returns the value of the **message** argument.");
        props.setProperty("commandSupportsJSON", "true");
        props.setProperty("commandExampleJSON", "{}");
        this.registerService(bc, (Object)new EchoCommandTaskFactory(), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("command", "quit");
        props.setProperty("commandNamespace", "command");
        props.setProperty("commandDescription", "Exit Cytoscape");
        props.setProperty("commandLongDescription", "This command causes Cytoscape to exit. It is typically used at the end of a script file");
        this.registerService(bc, (Object)new QuitTaskFactory(serviceRegistrar), TaskFactory.class, props);
        props = new Properties();
        props.setProperty("preferredMenu", "Tools");
        props.setProperty("title", "Execute Command File...");
        props.setProperty("command", "run");
        props.setProperty("commandNamespace", "command");
        props.setProperty("commandDescription", "Run a series of commands from a file");
        props.setProperty("inMenuBar", "true");
        props.setProperty("commandLongDescription", "The **run** command will execute a command script from the file pointed to by the ``file`` argument, which should contain Cytoscape commands, one per line. Arguments to the script are provided by the *args* argument");
        this.registerService(bc, (Object)new RunCommandsTaskFactory(commandExecutorTaskFactory), TaskFactory.class, props);
        AppsFinishedStartingListener scriptRunner = new AppsFinishedStartingListener(){

            public void handleEvent(AppsFinishedStartingEvent event) {
                CyProperty commandLineProps = (CyProperty)CyActivator.this.getService(bc, CyProperty.class, "(cyPropertyName=commandline.props)");
                String scriptFile = ((Properties)commandLineProps.getProperties()).getProperty("scriptFile");
                if (scriptFile != null) {
                    TaskIterator tasks = commandExecutorTaskFactory.createTaskIterator(new File(scriptFile), null);
                    SynchronousTaskManager taskManager = (SynchronousTaskManager)serviceRegistrar.getService(SynchronousTaskManager.class);
                    taskManager.execute(tasks);
                }
            }
        };
        this.registerService(bc, scriptRunner, AppsFinishedStartingListener.class, new Properties());
    }
}

