/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;

public class MultiLineTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    public static final String UPDATE_BOUNDS = "UpdateBounds";
    public static Object lastValueUserEntered;
    private ResizableTextArea textArea = new ResizableTextArea();
    private int lastRow = -1;
    private int thisRow = -1;

    public MultiLineTableCellEditor() {
        this.textArea.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.disabledForeground")));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.textArea});
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof KeyEvent) {
            int modifier;
            KeyEvent ke = (KeyEvent)e;
            int keyCode = ke.getKeyCode();
            if (LookAndFeelUtil.isMac() ? keyCode == 157 || keyCode == 17 : keyCode == 17 || keyCode == 524) {
                return false;
            }
            int n = modifier = LookAndFeelUtil.isAquaLAF() ? 256 : 128;
            if (ke.getKeyCode() == 67 && (ke.getModifiersEx() & modifier) == modifier) {
                return false;
            }
            return super.isCellEditable(e);
        }
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= 2;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastRow = row;
        this.thisRow = row;
        String text = value != null ? ((ValidatedObjectAndEditString)value).getEditString() : "";
        this.textArea.setTable(table);
        this.textArea.setText(text);
        return this.textArea;
    }

    class ResizableTextArea
    extends JTextArea
    implements KeyListener {
        private JTable table;
        private DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }
        };

        ResizableTextArea() {
            this.addKeyListener(this);
            MultiLineTableCellEditor.this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    ResizableTextArea.this.resetSize();
                    MultiLineTableCellEditor.this.lastRow = -1;
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    ResizableTextArea.this.resetSize();
                    MultiLineTableCellEditor.this.lastRow = -1;
                }
            });
        }

        public void setTable(JTable t) {
            this.table = t;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.updateBounds();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (Boolean.TRUE.equals(this.getClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS))) {
                super.setBounds(x, y, width, height);
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.getDocument().addDocumentListener(this.listener);
        }

        @Override
        public void removeNotify() {
            this.getDocument().removeDocumentListener(this.listener);
            super.removeNotify();
        }

        private void updateBounds() {
            if (this.table == null || !this.table.isEditing()) {
                return;
            }
            this.validate();
            Rectangle cellRect = this.table.getCellRect(this.table.getEditingRow(), this.table.getEditingColumn(), false);
            Dimension prefSize = this.getPreferredSize();
            this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.TRUE);
            this.setBounds(this.getX(), this.getY(), Math.min(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
            this.putClientProperty(MultiLineTableCellEditor.UPDATE_BOUNDS, Boolean.FALSE);
            this.validate();
            this.table.setRowHeight(this.table.getEditingRow(), this.getSize().height);
        }

        private void resetSize() {
            if (MultiLineTableCellEditor.this.lastRow < 0 || MultiLineTableCellEditor.this.lastRow > this.table.getRowCount()) {
                return;
            }
            this.table.setRowHeight(MultiLineTableCellEditor.this.lastRow, this.table.getRowHeight());
            super.setBounds(this.getX(), this.getY(), this.getSize().width, this.table.getRowHeight());
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            lastValueUserEntered = MultiLineTableCellEditor.this.getCellEditorValue();
        }

        @Override
        public void transferFocus() {
            if (MultiLineTableCellEditor.this.thisRow + 1 >= this.table.getRowCount()) {
                return;
            }
            super.transferFocus();
        }

        @Override
        public void transferFocusBackward() {
            if (MultiLineTableCellEditor.this.thisRow - 1 < 0) {
                return;
            }
            super.transferFocus();
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 27) {
                MultiLineTableCellEditor.this.cancelCellEditing();
                this.transferFocus();
                return;
            }
            if (evt.getKeyCode() != 10) {
                return;
            }
            int modifiers = evt.getModifiersEx();
            if (modifiers == 0) {
                MultiLineTableCellEditor.this.stopCellEditing();
                this.transferFocus();
                return;
            }
            if (evt.isShiftDown()) {
                MultiLineTableCellEditor.this.stopCellEditing();
                this.transferFocusBackward();
                return;
            }
            if (evt.isAltDown()) {
                int caretPosition = this.getCaretPosition();
                StringBuilder text = new StringBuilder(this.getText());
                this.setText(text.insert(caretPosition, '\n').toString());
                this.setCaretPosition(caretPosition + 1);
            }
        }
    }
}

