/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowsCreatedEvent;
import org.cytoscape.model.events.RowsCreatedListener;
import org.cytoscape.model.events.RowsDeletedEvent;
import org.cytoscape.model.events.RowsDeletedListener;
import org.cytoscape.model.events.TableAboutToBeDeletedEvent;
import org.cytoscape.model.events.TableAboutToBeDeletedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.presentation.property.table.TableModeVisualProperty;
import org.cytoscape.view.table.internal.util.TableBrowserUtil;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;

public final class BrowserTableModel
extends AbstractTableModel
implements RowsCreatedListener,
RowsDeletedListener,
TableAboutToBeDeletedListener {
    private final CyTableView tableView;
    private final CyTable dataTable;
    private final EquationCompiler compiler;
    private ViewMode viewMode;
    private List<String> attrNames;
    private List<CyRow> selectedRows;
    private Object[] rowIndexToPrimaryKey;
    private int maxRowIndex;
    private boolean disposed;
    private ReadWriteLock lock;

    public BrowserTableModel(CyTableView tableView, EquationCompiler compiler) {
        this.tableView = Objects.requireNonNull(tableView, "'tableView' must not be null");
        this.dataTable = (CyTable)tableView.getModel();
        this.compiler = compiler;
        this.viewMode = ViewMode.ALL;
        this.attrNames = this.getAttributeNames(this.dataTable);
        this.lock = new ReentrantReadWriteLock();
        List rows = this.dataTable.getAllRows();
        this.rowIndexToPrimaryKey = new Object[rows.size()];
        this.maxRowIndex = 0;
        String pkName = this.dataTable.getPrimaryKey().getName();
        for (CyRow row : rows) {
            this.rowIndexToPrimaryKey[this.maxRowIndex++] = row.getRaw(pkName);
        }
    }

    private List<String> getAttributeNames(CyTable table) {
        ArrayList<String> names = new ArrayList<String>();
        for (CyColumn column : table.getColumns()) {
            names.add(column.getName());
        }
        return names;
    }

    public CyTableView getTableView() {
        return this.tableView;
    }

    public CyTable getDataTable() {
        return this.dataTable;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ValidatedObjectAndEditString.class;
    }

    public List<String> getAllAttributeNames() {
        return new ArrayList<String>(this.attrNames);
    }

    @Override
    public int getRowCount() {
        Collection columns = this.dataTable.getColumns();
        if (columns.isEmpty()) {
            return 0;
        }
        int count = 0;
        switch (this.viewMode) {
            case SELECTED: {
                count = this.dataTable.countMatchingRows("selected", (Object)Boolean.TRUE);
                break;
            }
            case ALL: {
                count = this.dataTable.getRowCount();
                break;
            }
            case AUTO: {
                count = this.dataTable.countMatchingRows("selected", (Object)Boolean.TRUE);
                if (count != 0) break;
                count = this.dataTable.getRowCount();
            }
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        return this.attrNames.size();
    }

    public Object getValueAt(int rowIndex, String columnName) {
        CyRow row = this.getCyRow(rowIndex);
        return this.getValidatedObjectAndEditString(row, columnName);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String columnName = this.getColumnName(columnIndex);
        CyRow row = this.getCyRow(rowIndex);
        return this.getValidatedObjectAndEditString(row, columnName);
    }

    public CyColumn getCyColumn(int columnIndex) {
        String columnName = columnIndex >= 0 && columnIndex < this.getColumnCount() ? this.getColumnName(columnIndex) : null;
        return columnName != null ? this.dataTable.getColumn(columnName) : null;
    }

    public CyRow getCyRow(int rowIndex) {
        try {
            switch (this.viewMode) {
                case SELECTED: {
                    return rowIndex < this.getSelectedRows().size() ? this.getSelectedRows().get(rowIndex) : null;
                }
                case ALL: {
                    return this.dataTable.getRow(this.rowIndexToPrimaryKey[rowIndex]);
                }
                case AUTO: {
                    List<CyRow> selRows = this.getSelectedRows();
                    if (!selRows.isEmpty()) {
                        return rowIndex < selRows.size() ? selRows.get(rowIndex) : null;
                    }
                    return this.dataTable.getRow(this.rowIndexToPrimaryKey[rowIndex]);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    CyRow getCyRow(Object suid) {
        return this.dataTable.getRow(suid);
    }

    public int indexOfRow(CyRow row) {
        try {
            switch (this.viewMode) {
                case SELECTED: {
                    return this.indexOfRowFromSelected(row);
                }
                case ALL: {
                    return this.indexOfRowFromAll(row);
                }
                case AUTO: {
                    if (!this.getSelectedRows().isEmpty()) {
                        return this.indexOfRowFromSelected(row);
                    }
                    return this.indexOfRowFromAll(row);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private int indexOfRowFromAll(CyRow row) {
        String pkName = this.dataTable.getPrimaryKey().getName();
        Object pk = row.getRaw(pkName);
        for (int i = 0; i < this.rowIndexToPrimaryKey.length; ++i) {
            if (!pk.equals(this.rowIndexToPrimaryKey[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfRowFromSelected(CyRow row) {
        List<CyRow> selRows = this.getSelectedRows();
        for (int i = 0; i < selRows.size(); ++i) {
            if (!row.equals(selRows.get(i))) continue;
            return i;
        }
        return -1;
    }

    private List<CyRow> getSelectedRows() {
        if (this.selectedRows == null) {
            this.selectedRows = new ArrayList<CyRow>(this.dataTable.getMatchingRows("selected", (Object)true));
        }
        return this.selectedRows;
    }

    private ValidatedObjectAndEditString getValidatedObjectAndEditString(CyRow row, String columnName) {
        CyColumn column;
        if (row == null) {
            return null;
        }
        Object raw = row.getRaw(columnName);
        if (raw == null && (column = row.getTable().getColumn(columnName)) != null) {
            raw = column.getDefaultValue();
        }
        if (raw == null) {
            return null;
        }
        boolean isEquation = raw instanceof Equation;
        Object cooked = isEquation ? BrowserTableModel.getColumnValue(row, columnName) : raw;
        String editString = this.createEditString(raw);
        String lastInternalError = this.dataTable.getLastInternalError();
        if (cooked != null || lastInternalError == "") {
            return new ValidatedObjectAndEditString(cooked, editString, isEquation);
        }
        return new ValidatedObjectAndEditString(cooked, editString, lastInternalError, isEquation);
    }

    @Override
    public void fireTableStructureChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableStructureChanged();
        } else {
            BrowserTableModel model = this;
            SwingUtilities.invokeLater(() -> model.fireTableStructureChanged());
        }
    }

    @Override
    public void fireTableDataChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableDataChanged();
        } else {
            BrowserTableModel model = this;
            SwingUtilities.invokeLater(() -> model.fireTableDataChanged());
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableChanged(event);
        } else {
            BrowserTableModel model = this;
            SwingUtilities.invokeLater(() -> model.fireTableChanged(event));
        }
    }

    private String createEditString(Object raw) {
        if (raw instanceof List) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            boolean first = true;
            for (Object item : (List)raw) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                if (item instanceof String) {
                    builder.append('\"');
                    this.escape(item.toString(), builder);
                    builder.append('\"');
                    continue;
                }
                builder.append(item.toString());
            }
            builder.append(']');
            return builder.toString();
        }
        return raw.toString();
    }

    private void escape(String string, StringBuilder builder) {
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                default: {
                    builder.append(c);
                }
            }
        }
    }

    private static Object getColumnValue(CyRow row, String columnName) {
        CyColumn column = row.getTable().getColumn(columnName);
        if (column.getType() == List.class) {
            Class listElementType = column.getListElementType();
            return row.getList(columnName, listElementType);
        }
        return row.get(columnName, column.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RowsCreatedEvent e) {
        this.lock.writeLock().lock();
        try {
            if (!((CyTable)e.getSource()).equals(this.dataTable)) {
                return;
            }
            this.selectedRows = null;
            Object[] newRowIndex = new Object[this.rowIndexToPrimaryKey.length + e.getPayloadCollection().size()];
            System.arraycopy(this.rowIndexToPrimaryKey, 0, newRowIndex, 0, this.rowIndexToPrimaryKey.length);
            this.rowIndexToPrimaryKey = newRowIndex;
            for (Object pk : e.getPayloadCollection()) {
                this.rowIndexToPrimaryKey[this.maxRowIndex++] = pk;
            }
            this.fireTableDataChanged();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RowsDeletedEvent e) {
        this.lock.writeLock().lock();
        try {
            if (!((CyTable)e.getSource()).equals(this.dataTable)) {
                return;
            }
            int index = 0;
            List rows = this.dataTable.getAllRows();
            String pkName = this.dataTable.getPrimaryKey().getName();
            this.rowIndexToPrimaryKey = new Object[rows.size()];
            for (CyRow row : rows) {
                this.rowIndexToPrimaryKey[index++] = row.getRaw(pkName);
            }
            this.maxRowIndex = index;
            this.selectedRows = null;
            this.fireTableDataChanged();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void handleEvent(TableAboutToBeDeletedEvent e) {
        this.lock.writeLock().lock();
        try {
            if (!e.getTable().equals(this.dataTable)) {
                return;
            }
            this.disposed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setViewMode(ViewMode viewMode) {
        this.selectedRows = null;
        CyColumn selectedColumn = this.dataTable.getColumn("selected");
        this.viewMode = viewMode != ViewMode.ALL && selectedColumn != null && selectedColumn.getType() == Boolean.class ? viewMode : ViewMode.ALL;
    }

    public void updateViewMode() {
        this.fireTableDataChanged();
    }

    ViewMode getViewMode() {
        return this.viewMode;
    }

    public String getCyColumnName(int column) {
        return (String)this.dataTable.getColumns().toArray()[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.mapColumnIndexToColumnName(column);
    }

    public int mapColumnNameToColumnIndex(String columnName) {
        if (this.attrNames.contains(columnName)) {
            return this.attrNames.indexOf(columnName);
        }
        return -1;
    }

    private String mapColumnIndexToColumnName(int index) {
        if (index >= 0 && index <= this.attrNames.size()) {
            return this.attrNames.get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        String text = (String)value;
        CyRow row = this.getCyRow(rowIndex);
        String columnName = this.mapColumnIndexToColumnName(columnIndex);
        Class columnType = this.dataTable.getColumn(columnName).getType();
        Class listElementType = this.dataTable.getColumn(columnName).getListElementType();
        if (text.isEmpty()) {
            if (!row.isSet(columnName)) {
                return;
            }
            row.set(columnName, null);
        } else if (text.startsWith("=")) {
            Map<String, Class<?>> attrNameToTypeMap = TableBrowserUtil.getAttNameToTypeMap(this.dataTable, null);
            if (this.compiler.compile(text, attrNameToTypeMap)) {
                Equation eqn = this.compiler.getEquation();
                Class eqnType = eqn.getType();
                if (this.eqnTypeIsCompatible(columnType, listElementType, eqnType)) {
                    row.set(columnName, (Object)eqn);
                } else {
                    Class expectedType = columnType == Integer.class ? Long.class : columnType;
                    String errorMsg = "Equation result type is " + this.getUnqualifiedName(eqnType) + ", column type is " + this.getUnqualifiedName(columnType) + ".";
                    Equation errorEqn = this.compiler.getErrorEquation(text, expectedType, errorMsg);
                    row.set(columnName, (Object)errorEqn);
                }
            } else {
                Class eqnType = columnType == Integer.class ? Long.class : columnType;
                String errorMsg = this.compiler.getLastErrorMsg();
                Equation errorEqn = this.compiler.getErrorEquation(text, eqnType, errorMsg);
                row.set(columnName, (Object)errorEqn);
            }
        } else {
            List<Object> parsedData = TableBrowserUtil.parseCellInput(this.dataTable, columnName, value);
            if (parsedData.get(0) != null) {
                row.set(columnName, parsedData.get(0));
            } else {
                BrowserTableModel.showErrorWindow(parsedData.get(1).toString());
            }
        }
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
        this.fireTableChanged(event);
        this.fireTableDataChanged();
    }

    private static void showErrorWindow(String errMessage) {
        JOptionPane.showMessageDialog(null, errMessage, "Invalid Value", 0);
    }

    private boolean eqnTypeIsCompatible(Class<?> columnType, Class<?> listElementType, Class<?> eqnType) {
        return EquationUtil.eqnTypeIsCompatible(columnType, listElementType, eqnType);
    }

    private String getUnqualifiedName(Class<?> type) {
        String typeName = type.getName();
        int lastDotPos = typeName.lastIndexOf(46);
        return lastDotPos == -1 ? typeName : typeName.substring(lastDotPos + 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        CyColumn column = this.getCyColumn(columnIndex);
        return column == null ? false : !column.isPrimaryKey();
    }

    public boolean isPrimaryKey(int columnIndex) {
        CyColumn column = columnIndex >= 0 && columnIndex < this.getColumnCount() ? this.getCyColumn(columnIndex) : null;
        return column == null ? false : column.isPrimaryKey();
    }

    void clearSelectedRows() {
        this.selectedRows = null;
    }

    void setColumnName(int index, String name) {
        this.attrNames.set(index, name);
    }

    void removeColumn(int index) {
        this.attrNames.remove(index);
    }

    void addColumn(String name) {
        this.attrNames.add(name);
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    private static void dumpTable(CyTable table) {
        System.out.println("Begin Table: " + table.getTitle());
        Collection cols = table.getColumns();
        for (CyColumn col : cols) {
            System.out.print(col.getName());
            System.out.print('\t');
        }
        System.out.println();
        for (CyColumn col : cols) {
            System.out.print(col.getType().getSimpleName());
            System.out.print('\t');
        }
        System.out.println();
        for (CyRow row : table.getAllRows()) {
            for (CyColumn col : cols) {
                System.out.print(row.getRaw(col.getName()));
                System.out.print('\t');
            }
            System.out.println();
        }
        System.out.println("End Table");
        System.out.println();
    }

    public static enum ViewMode {
        ALL,
        SELECTED,
        AUTO;


        public static ViewMode fromVisualPropertyValue(TableMode tableMode) {
            if (tableMode == TableModeVisualProperty.ALL) {
                return ALL;
            }
            if (tableMode == TableModeVisualProperty.SELECTED) {
                return SELECTED;
            }
            return AUTO;
        }

        public TableMode toVisualPropertyValue() {
            switch (this) {
                case ALL: {
                    return TableModeVisualProperty.ALL;
                }
                case SELECTED: {
                    return TableModeVisualProperty.SELECTED;
                }
            }
            return TableModeVisualProperty.AUTO;
        }
    }
}

