/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModelGravityEvent;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModelListener;

public class BrowserTableColumnModel
extends DefaultTableColumnModel {
    private final Map<TableColumn, Double> gravities = new HashMap<TableColumn, Double>();
    private final Set<TableColumn> visibleColumns = new HashSet<TableColumn>();
    private final List<BrowserTableColumnModelListener> listeners = new CopyOnWriteArrayList<BrowserTableColumnModelListener>();

    public void addColumn(TableColumn col, Long viewSuid, boolean isVisible, double gravity) {
        col.setIdentifier(viewSuid);
        this.gravities.put(col, gravity);
        if (isVisible) {
            this.visibleColumns.add(col);
            super.addColumn(col);
        }
    }

    @Override
    public int getColumnIndex(Object viewSuid) {
        if (viewSuid == null) {
            return -1;
        }
        int index = 0;
        for (TableColumn col : this.tableColumns) {
            if (viewSuid.equals(col.getIdentifier())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void deleteColumn(TableColumn column) {
        this.gravities.remove(column);
        super.removeColumn(column);
    }

    public void addBrowserTableColumnModelListener(BrowserTableColumnModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeBrowserTableColumnModelListener(BrowserTableColumnModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        super.addColumn(aColumn);
    }

    public boolean isVisible(TableColumn col) {
        return this.visibleColumns.contains(col);
    }

    public TableColumn getTableColumn(Long suid) {
        for (TableColumn col : this.gravities.keySet()) {
            if (!suid.equals(col.getIdentifier())) continue;
            return col;
        }
        return null;
    }

    private int getSetVisibleIndex(TableColumn col) {
        ArrayList<Map.Entry<TableColumn, Double>> list = new ArrayList<Map.Entry<TableColumn, Double>>(this.gravities.entrySet());
        list.sort(Map.Entry.comparingByValue());
        int i = 0;
        for (Map.Entry<TableColumn, Double> entry : list) {
            TableColumn curCol = entry.getKey();
            if (curCol == col) {
                return i;
            }
            if (!this.isVisible(curCol)) continue;
            ++i;
        }
        throw new IllegalArgumentException("Table Column not found");
    }

    public void setColumnVisible(TableColumn col, boolean visible) {
        if (visible == this.isVisible(col)) {
            return;
        }
        if (visible) {
            int visibleIndex = this.getSetVisibleIndex(col);
            this.visibleColumns.add(col);
            int index = this.getColumnCount();
            this.addColumn(col);
            if (index != visibleIndex) {
                super.moveColumn(index, visibleIndex);
            }
        } else {
            this.visibleColumns.remove(col);
            this.removeColumn(col);
        }
    }

    public void setColumnGravity(TableColumn col, double gravity) {
        this.gravities.put(col, gravity);
    }

    public void reorderColumnsToRespectGravity() {
        ArrayList<Map.Entry<TableColumn, Double>> list = new ArrayList<Map.Entry<TableColumn, Double>>(this.gravities.entrySet());
        list.sort(Map.Entry.comparingByValue());
        int i = 0;
        for (Map.Entry<TableColumn, Double> entry : list) {
            TableColumn curCol = entry.getKey();
            if (!this.isVisible(curCol)) continue;
            int index = super.getColumnIndex(curCol.getIdentifier());
            if (index != i) {
                super.moveColumn(index, i);
            }
            ++i;
        }
    }

    public int getColumnCount(boolean onlyVisible) {
        return onlyVisible ? super.getColumnCount() : this.gravities.size();
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        BrowserTableColumnModelGravityEvent event = null;
        if (columnIndex != newIndex) {
            TableColumn c1 = super.getColumn(columnIndex);
            TableColumn c2 = super.getColumn(newIndex);
            Double g1 = this.gravities.get(c1);
            Double g2 = this.gravities.get(c2);
            this.gravities.put(c1, g2);
            this.gravities.put(c2, g1);
            Long c1Suid = (Long)c1.getIdentifier();
            Long c2Suid = (Long)c2.getIdentifier();
            event = new BrowserTableColumnModelGravityEvent(c1Suid, g2, c2Suid, g1);
        }
        super.moveColumn(columnIndex, newIndex);
        if (event != null) {
            for (BrowserTableColumnModelListener listener : this.listeners) {
                listener.columnGravityChanged(event);
            }
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        for (TableColumn column : this.gravities.keySet()) {
            if (column.getModelIndex() != modelColumnIndex) continue;
            return column;
        }
        return null;
    }
}

