/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.table.internal.equation.EquationEditorMediator;
import org.cytoscape.view.table.internal.equation.SyntaxAreaFactory;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class SyntaxAreaPanel
extends JPanel {
    private final CyServiceRegistrar registrar;
    private final IconManager iconManager;
    private final BrowserTable browserTable;
    private JPanel topPanel;
    private RSyntaxTextArea textArea;
    private JScrollPane syntaxAreaScrollPane;
    private JButton clearButton;
    private JButton undoButton;
    private JButton redoButton;
    private JLabel applyLabel;
    private JComboBox<EquationEditorMediator.ApplyScope> applyScopeCombo;
    private JButton applyButton;
    private JButton evalButton;
    private JLabel resultLabel;

    public SyntaxAreaPanel(CyServiceRegistrar registrar, BrowserTable browserTable) {
        this.registrar = registrar;
        this.browserTable = browserTable;
        this.iconManager = (IconManager)registrar.getService(IconManager.class);
        this.init();
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getTopPanel()).addComponent(this.getSyntaxAreaScrollPane()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getApplyLabel()).addComponent(this.getApplyScopeCombo()).addComponent(this.getApplyButton()).addComponent(this.getEvalButton()).addComponent(this.getResultLabel())));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getTopPanel()).addComponent(this.getSyntaxAreaScrollPane()).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.getApplyLabel()).addComponent(this.getApplyScopeCombo(), 0, 150, 150).addComponent(this.getApplyButton()).addComponent(this.getEvalButton()).addComponent(this.getResultLabel())));
        this.getUndoButton().addActionListener(e -> this.undo());
        this.getRedoButton().addActionListener(e -> this.redo());
        this.getClearButton().addActionListener(e -> this.clear());
        this.getSyntaxTextArea().addCaretListener(e -> this.clearResultLabel());
        this.getSyntaxTextArea().getDocument().addDocumentListener(e -> this.updateApplyButtonEnablement());
        this.updateApplyButtonEnablement();
        this.setCaret(0);
    }

    public EquationEditorMediator.ApplyScope getApplyScope() {
        return (EquationEditorMediator.ApplyScope)((Object)this.getApplyScopeCombo().getSelectedItem());
    }

    public int getCaretPosition() {
        return this.getSyntaxTextArea().getCaretPosition();
    }

    public void setText(String text) {
        this.getSyntaxTextArea().setText(text == null ? "" : text);
        this.updateApplyButtonEnablement();
    }

    public String getText() {
        return this.getSyntaxTextArea().getText();
    }

    public void insertText(int offset, String text, String post) {
        try {
            this.getSyntaxTextArea().getDocument().insertString(offset, text, null);
            int caretPos = offset + text.length();
            if (post != null) {
                this.getSyntaxTextArea().getDocument().insertString(caretPos, post, null);
            }
            this.setCaret(caretPos);
            this.getSyntaxTextArea().grabFocus();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void showEvalSuccess(int numRows) {
        this.clearResultLabel();
        if (numRows == 1) {
            this.showResult("1 row updated");
        } else if (numRows > 1) {
            this.showResult(numRows + " rows updated");
        }
    }

    public void showSyntaxError(int location, String message) {
        this.clearResultLabel();
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.createErrorPopupLabel(message, true));
        try {
            RSyntaxTextArea textArea = this.getSyntaxTextArea();
            Rectangle rectangle = textArea.modelToView(location);
            textArea.scrollRectToVisible(rectangle);
            rectangle = textArea.modelToView(location);
            popup.show((Component)textArea, rectangle.x, rectangle.y + rectangle.height);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void showEvalError(int numRows, int numErrors, Collection<String> messages) {
        this.clearResultLabel();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridLayout(messages.size(), 1));
        if (numRows == 1) {
            panel.setLayout(new GridLayout(1, 1));
            panel.add(this.createErrorPopupLabel(messages.iterator().next(), true));
        } else {
            panel.setLayout(new GridLayout(messages.size() + 1, 1));
            StringBuilder sb = new StringBuilder("Applied to ").append(numRows).append(" rows, ");
            if (numErrors == 1) {
                sb.append("1 row had an error");
            } else {
                sb.append(numErrors).append(" rows had errors");
            }
            panel.add(this.createErrorPopupLabel(sb.toString(), true));
            for (String error : messages) {
                panel.add(this.createErrorPopupLabel(error, false));
            }
        }
        JPopupMenu popup = new JPopupMenu();
        popup.add(panel);
        JButton comp = this.getApplyButton();
        popup.show(comp, 0, comp.getHeight());
    }

    private JLabel createErrorPopupLabel(String text, boolean includeIcon) {
        JLabel label = new JLabel(text);
        label.setForeground(Color.RED);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
        label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        if (includeIcon) {
            label.setIcon((Icon)new TextIcon("\uf06a", this.iconManager.getIconFont(11.0f), Color.RED, 10, 10));
        }
        return label;
    }

    private void setCaret(int offset) {
        this.getSyntaxTextArea().setCaretPosition(offset);
        this.getSyntaxTextArea().getCaret().setVisible(true);
    }

    public void undo() {
        this.getSyntaxTextArea().undoLastAction();
    }

    public void redo() {
        this.getSyntaxTextArea().redoLastAction();
    }

    public void clear() {
        this.getSyntaxTextArea().setText("");
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            JLabel label = new JLabel("Formula Editor");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
            this.topPanel = new JPanel();
            this.topPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
            this.topPanel.add(label);
            this.topPanel.add(Box.createHorizontalGlue());
            this.topPanel.add(this.getClearButton());
            this.topPanel.add(this.getUndoButton());
            this.topPanel.add(this.getRedoButton());
        }
        return this.topPanel;
    }

    private JScrollPane getSyntaxAreaScrollPane() {
        if (this.syntaxAreaScrollPane == null) {
            this.syntaxAreaScrollPane = new JScrollPane((Component)this.getSyntaxTextArea());
        }
        return this.syntaxAreaScrollPane;
    }

    public RSyntaxTextArea getSyntaxTextArea() {
        if (this.textArea == null) {
            this.textArea = SyntaxAreaFactory.createEquationTextArea(this.registrar);
        }
        return this.textArea;
    }

    public JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = this.createIconButton("\uf1f8", "Clear");
            this.clearButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        }
        return this.clearButton;
    }

    public JButton getUndoButton() {
        if (this.undoButton == null) {
            this.undoButton = this.createIconButton("\uf0e2", "Undo");
        }
        return this.undoButton;
    }

    public JButton getRedoButton() {
        if (this.redoButton == null) {
            this.redoButton = this.createIconButton("\uf01e", "Redo");
        }
        return this.redoButton;
    }

    private JLabel getApplyLabel() {
        if (this.applyLabel == null) {
            this.applyLabel = new JLabel("Apply to:");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.applyLabel});
        }
        return this.applyLabel;
    }

    private JLabel getResultLabel() {
        if (this.resultLabel == null) {
            this.resultLabel = new JLabel();
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.resultLabel});
        }
        return this.resultLabel;
    }

    private void clearResultLabel() {
        this.getResultLabel().setText("");
    }

    private void showResult(String text) {
        this.getResultLabel().setText(text);
    }

    private JComboBox<EquationEditorMediator.ApplyScope> getApplyScopeCombo() {
        if (this.applyScopeCombo == null) {
            EquationEditorMediator.ApplyScope[] scopes = EquationEditorMediator.ApplyScope.values(this.tableHasSelected());
            this.applyScopeCombo = new JComboBox<EquationEditorMediator.ApplyScope>(scopes);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.applyScopeCombo});
        }
        return this.applyScopeCombo;
    }

    public JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton("Insert Formula");
            this.applyButton.setToolTipText("Insert the formula into the selected cells. The formula will be re-evaluated as needed.");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.applyButton});
        }
        return this.applyButton;
    }

    public JButton getEvalButton() {
        if (this.evalButton == null) {
            this.evalButton = new JButton("Evaluate and Insert Result");
            this.evalButton.setToolTipText("Evaluate the formula now and insert the result into the selected cells.");
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.evalButton});
        }
        return this.evalButton;
    }

    private void updateApplyButtonEnablement() {
        boolean enabled = !this.getText().isBlank();
        this.getApplyButton().setEnabled(enabled);
        this.getEvalButton().setEnabled(enabled);
    }

    private JButton createIconButton(String icon, String tooltip) {
        IconManager iconManager = (IconManager)this.registrar.getService(IconManager.class);
        JButton button = new JButton(icon);
        button.setToolTipText(tooltip);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setFont(iconManager.getIconFont(14.0f));
        button.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        return button;
    }

    private boolean tableHasSelected() {
        CyColumn selectedColumn = this.browserTable.getBrowserTableModel().getDataTable().getColumn("selected");
        return selectedColumn != null && selectedColumn.getType() == Boolean.class;
    }

    @FunctionalInterface
    private static interface DocumentListenerAdapter
    extends DocumentListener {
        @Override
        default public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void update(DocumentEvent var1);
    }
}

