/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.cytoscape.util.swing.LookAndFeelUtil;

public abstract class ItemPanel
extends JPanel {
    private final String title;
    private JPanel topPanel;
    private JScrollPane scrollPane;

    public abstract JComponent getContent();

    public ItemPanel(String title) {
        this.title = title;
        this.init();
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getTopPanel()).addComponent(this.getScrollPane()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getTopPanel()).addComponent(this.getScrollPane()));
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            JLabel label = new JLabel(this.title);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{label});
            this.topPanel = new JPanel();
            this.topPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
            this.topPanel.add(label);
            this.topPanel.add(Box.createHorizontalGlue());
        }
        return this.topPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getContent());
            this.scrollPane.setVerticalScrollBarPolicy(22);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.scrollPane;
    }
}

