/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.equations.Equation;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.table.internal.equation.EquationEditorMediator;
import org.cytoscape.view.table.internal.impl.BrowserTable;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;

public class EquationEditorDialogFactory {
    private final CyServiceRegistrar registrar;
    private final Map<Long, String> storedEquations = new HashMap<Long, String>();

    public EquationEditorDialogFactory(CyServiceRegistrar registrar) {
        this.registrar = registrar;
    }

    public void openEquationEditorDialog(BrowserTable browserTable) {
        String equationNotApplied;
        long colSUID = EquationEditorDialogFactory.getColSUID(browserTable);
        String initialEquation = this.storedEquations.get(colSUID);
        if (initialEquation == null) {
            initialEquation = EquationEditorDialogFactory.getEquationInCell(browserTable);
        }
        if ((equationNotApplied = EquationEditorMediator.openEquationEditorDialog(browserTable, initialEquation, this.registrar)) == null || equationNotApplied.isBlank()) {
            this.storedEquations.remove(colSUID);
        } else {
            this.storedEquations.put(colSUID, equationNotApplied.trim());
        }
    }

    private static long getColSUID(BrowserTable browserTable) {
        int modelColIndex = browserTable.convertColumnIndexToModel(browserTable.getSelectedColumn());
        CyColumn column = browserTable.getBrowserTableModel().getCyColumn(modelColIndex);
        return column.getSUID();
    }

    private static String getEquationInCell(BrowserTable browserTable) {
        int cellRow = browserTable.getSelectedRow();
        int cellCol = browserTable.getSelectedColumn();
        BrowserTableModel model = browserTable.getBrowserTableModel();
        try {
            CyRow row = model.getCyRow(cellRow);
            String colName = browserTable.getColumnName(cellCol);
            Object obj = row.getRaw(colName);
            if (obj instanceof Equation) {
                Equation equation = (Equation)obj;
                return equation.toString().trim().substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

