/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.graphml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.group.CyGroupSettingsManager;
import org.cytoscape.io.internal.read.graphml.GraphMLParser;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class GraphMLReader
extends AbstractCyNetworkReader {
    private InputStream inputStream;
    private final CyLayoutAlgorithmManager layouts;
    private final CyRootNetworkManager cyRootNetworkManager;
    private final CyGroupFactory cyGroupFactory;
    private final CyGroupManager cyGroupManager;
    private final CyGroupSettingsManager cyGroupSettings;
    private final List<CyGroup> cyGroups;
    private GraphMLParser parser;
    private TaskMonitor taskMonitor;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GraphMLReader(InputStream inputStream, CyLayoutAlgorithmManager layouts, CyApplicationManager cyApplicationManager, CyNetworkFactory cyNetworkFactory, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager, CyServiceRegistrar cyServiceRegistrar) {
        super(inputStream, cyApplicationManager, cyNetworkFactory, cyNetworkManager, cyRootNetworkManager);
        if (inputStream == null) {
            throw new NullPointerException("Input stream is null");
        }
        this.inputStream = inputStream;
        this.layouts = layouts;
        this.cyRootNetworkManager = cyRootNetworkManager;
        this.cyGroupFactory = (CyGroupFactory)cyServiceRegistrar.getService(CyGroupFactory.class);
        this.cyGroupManager = (CyGroupManager)cyServiceRegistrar.getService(CyGroupManager.class);
        this.cyGroupSettings = (CyGroupSettingsManager)cyServiceRegistrar.getService(CyGroupSettingsManager.class);
        this.cyGroups = new ArrayList<CyGroup>();
    }

    public CyNetwork[] getNetworks() {
        if (this.parser == null) {
            throw new IllegalStateException("Parser is not initialized.");
        }
        return this.parser.getCyNetworks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        try {
            CySubNetwork newNetwork;
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser sp = spf.newSAXParser();
            XMLReader xmlReader = sp.getXMLReader();
            CyRootNetwork root = this.getRootNetwork();
            if (root != null) {
                newNetwork = root.addSubNetwork();
            } else {
                newNetwork = (CySubNetwork)this.cyNetworkFactory.createNetwork();
                root = newNetwork.getRootNetwork();
            }
            this.parser = new GraphMLParser(taskMonitor, this.cyNetworkFactory, this.cyRootNetworkManager, root, (CyNetwork)newNetwork);
            xmlReader.setContentHandler(this.parser);
            InputSource inputSource = new InputSource(this.inputStream);
            inputSource.setEncoding("UTF-8");
            xmlReader.parse(inputSource);
            this.createGroups(root, newNetwork);
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (Exception e) {
                    logger.warn("Cannot close GraphML input stream", (Throwable)e);
                }
            }
        }
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        CyNetworkView view = this.getNetworkViewFactory().createNetworkView(network);
        for (CyGroup group : this.cyGroups) {
            this.cyGroupSettings.setGroupViewType(group, CyGroupSettingsManager.GroupViewType.SINGLENODE);
            this.cyGroupSettings.setGroupViewType(group, CyGroupSettingsManager.GroupViewType.COMPOUND);
        }
        CyLayoutAlgorithm layout = this.layouts.getDefaultLayout();
        String attribte = this.layouts.getLayoutAttribute(layout, view);
        TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, attribte);
        Task nextTask = itr.next();
        try {
            nextTask.run(this.taskMonitor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not finish layout", e);
        }
        return view;
    }

    private void createGroups(CyRootNetwork root, CySubNetwork net) {
        for (CySubNetwork subnet : root.getSubNetworkList()) {
            if (subnet == net) continue;
            CyGroup group = this.cyGroupFactory.createGroup((CyNetwork)net, subnet.getNodeList(), null, true);
            CyNode groupNode = group.getGroupNode();
            net.addNode(groupNode);
            this.cyGroups.add(group);
            String groupName = (String)subnet.getRow((CyIdentifiable)subnet).get("name", String.class);
            CyRow sharedRow = root.getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS");
            sharedRow.set("shared name", (Object)groupName);
            net.getRow((CyIdentifiable)groupNode).set("name", (Object)groupName);
        }
    }
}

