/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.graphml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.cytoscape.io.internal.read.graphml.GraphMLToken;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLParser
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private Map<String, String> datatypeMap;
    private Map<String, String> datanameMap;
    private CyIdentifiable currentObject;
    private String currentAttributeKey;
    private String currentAttributeData;
    private String currentAttributeType;
    private String currentTag;
    private final CyRootNetworkManager rootNetworkManager;
    private boolean directed = true;
    private final Stack<CyNetwork> networkStack;
    private final List<CyNetwork> cyNetworks;
    private CyNetwork currentNetwork;
    private final Map<String, CyIdentifiable> nodeid2CyNodeMap;
    private String lastTag;
    private CyNode lastNode;
    private StringBuilder builder;
    private final CyRootNetwork root;
    private final CyNetwork newNetwork;

    GraphMLParser(TaskMonitor tm, CyNetworkFactory networkFactory, CyRootNetworkManager rootNetworkManager, CyRootNetwork root, CyNetwork newNetwork) {
        this.rootNetworkManager = rootNetworkManager;
        this.networkStack = new Stack();
        this.cyNetworks = new ArrayList<CyNetwork>();
        this.datatypeMap = new HashMap<String, String>();
        this.datanameMap = new HashMap<String, String>();
        this.nodeid2CyNodeMap = new HashMap<String, CyIdentifiable>();
        this.root = root;
        this.newNetwork = newNetwork;
    }

    CyNetwork[] getCyNetworks() {
        return this.cyNetworks.toArray(new CyNetwork[0]);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() throws SAXException {
        this.datatypeMap.clear();
        this.datatypeMap = null;
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        this.builder = new StringBuilder();
        this.currentTag = qName;
        if (qName.equals(GraphMLToken.GRAPH.getTag())) {
            this.createGraph(atts);
        } else if (qName.equals(GraphMLToken.KEY.getTag())) {
            this.datatypeMap.put(atts.getValue(GraphMLToken.ID.getTag()), atts.getValue(GraphMLToken.ATTRTYPE.getTag()));
            this.datanameMap.put(atts.getValue(GraphMLToken.ID.getTag()), atts.getValue(GraphMLToken.ATTRNAME.getTag()));
        } else if (qName.equals(GraphMLToken.NODE.getTag())) {
            this.createNode(atts);
        } else if (qName.equals(GraphMLToken.EDGE.getTag())) {
            this.createEdge(atts);
        } else if (qName.equals(GraphMLToken.DATA.getTag())) {
            this.currentAttributeKey = atts.getValue(GraphMLToken.KEY.getTag());
            this.currentAttributeType = this.datatypeMap.get(this.currentAttributeKey);
        } else if (qName.equals(GraphMLToken.DESC.getTag())) {
            this.currentAttributeKey = GraphMLToken.DESC.getTag();
            this.currentAttributeType = GraphMLToken.STRING.getTag();
            this.datanameMap.put(GraphMLToken.DESC.getTag(), "name");
        }
    }

    private void createGraph(Attributes atts) {
        String networkID = atts.getValue(GraphMLToken.ID.getTag());
        if (this.networkStack.size() == 0) {
            this.currentNetwork = this.newNetwork == null ? this.root.addSubNetwork() : this.newNetwork;
        } else {
            CyNetwork parentNetwork = this.networkStack.peek();
            this.currentNetwork = this.rootNetworkManager.getRootNetwork(parentNetwork).addSubNetwork();
            if (this.lastTag != null && this.lastTag.equals(GraphMLToken.NODE.getTag())) {
                ArrayList<CyNode> toBeRemoved = new ArrayList<CyNode>();
                toBeRemoved.add(this.lastNode);
                for (CyNetwork network : this.networkStack) {
                    network.removeNodes(toBeRemoved);
                }
            }
        }
        this.currentNetwork.getRow((CyIdentifiable)this.currentNetwork).set("name", (Object)networkID);
        this.networkStack.push(this.currentNetwork);
        this.cyNetworks.add(this.currentNetwork);
        String edef = atts.getValue(GraphMLToken.EDGEDEFAULT.getTag());
        this.directed = GraphMLToken.DIRECTED.getTag().equalsIgnoreCase(edef);
    }

    private void createNode(Attributes atts) {
        String currentAttributeID = atts.getValue(GraphMLToken.ID.getTag());
        if (this.networkStack.size() > 1) {
            CyNetwork rootNetwork = (CyNetwork)this.networkStack.get(0);
            this.currentObject = this.nodeid2CyNodeMap.get(currentAttributeID);
            if (this.currentObject == null) {
                this.currentObject = rootNetwork.addNode();
                rootNetwork.getRow(this.currentObject).set("name", (Object)currentAttributeID);
                this.nodeid2CyNodeMap.put(currentAttributeID, this.currentObject);
            }
            for (CyNetwork network : this.networkStack) {
                if (network == rootNetwork) continue;
                ((CySubNetwork)network).addNode((CyNode)this.currentObject);
                network.getRow(this.currentObject).set("name", (Object)currentAttributeID);
            }
        } else {
            this.currentObject = this.nodeid2CyNodeMap.get(currentAttributeID);
            if (this.currentObject == null) {
                this.currentObject = this.currentNetwork.addNode();
                this.currentNetwork.getRow(this.currentObject).set("name", (Object)currentAttributeID);
                this.nodeid2CyNodeMap.put(currentAttributeID, this.currentObject);
            }
        }
        this.lastNode = (CyNode)this.currentObject;
    }

    private void createEdge(Attributes atts) {
        String currentEdgeSourceName = atts.getValue(GraphMLToken.SOURCE.getTag());
        String currentEdgeTargetName = atts.getValue(GraphMLToken.TARGET.getTag());
        CyNode sourceNode = (CyNode)this.nodeid2CyNodeMap.get(currentEdgeSourceName);
        CyNode targetNode = (CyNode)this.nodeid2CyNodeMap.get(currentEdgeTargetName);
        if (this.networkStack.size() > 1) {
            CyNetwork rootNetwork = (CyNetwork)this.networkStack.get(0);
            this.currentObject = rootNetwork.addEdge(sourceNode, targetNode, this.directed);
            rootNetwork.getRow(this.currentObject).set("name", (Object)(currentEdgeSourceName + " (-) " + currentEdgeTargetName));
            rootNetwork.getRow(this.currentObject).set("interaction", (Object)"-");
            for (CyNetwork network : this.networkStack) {
                if (network == rootNetwork) continue;
                ((CySubNetwork)network).addEdge((CyEdge)this.currentObject);
            }
        } else {
            try {
                this.currentObject = this.currentNetwork.addEdge(sourceNode, targetNode, this.directed);
                this.currentNetwork.getRow(this.currentObject).set("name", (Object)(currentEdgeSourceName + " (-) " + currentEdgeTargetName));
                this.currentNetwork.getRow(this.currentObject).set("interaction", (Object)"-");
            }
            catch (Exception e) {
                logger.warn("Edge entry ignored: " + currentEdgeSourceName + " (-) " + currentEdgeTargetName, (Throwable)e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentAttributeData = String.valueOf(ch, start, length);
        this.builder.append(this.currentAttributeData);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.parseString();
        this.lastTag = qName;
        if (this.networkStack.size() > 1 && qName == GraphMLToken.GRAPH.getTag()) {
            this.networkStack.pop();
            this.currentNetwork = this.networkStack.peek();
        }
    }

    private void parseString() {
        String finalString = this.builder.toString().trim();
        if (finalString.isEmpty()) {
            return;
        }
        if (this.currentTag.equals(GraphMLToken.DESC.getTag()) || this.currentTag.equals(GraphMLToken.DATA.getTag())) {
            this.parseData(finalString);
        } else if (this.currentTag.equals(GraphMLToken.DEFAULT.getTag())) {
            // empty if block
        }
    }

    private final void parseData(String finalString) {
        CyRow row;
        CyColumn column;
        CyTable table;
        GraphMLToken attrTag = GraphMLToken.getType(this.currentAttributeType);
        if (attrTag == null || attrTag.getDataType() == null) {
            return;
        }
        String columnName = this.datanameMap.get(this.currentAttributeKey);
        if (this.currentObject == null) {
            table = this.currentNetwork.getDefaultNetworkTable();
            column = table.getColumn(columnName);
            row = table.getRow((Object)this.currentNetwork.getSUID());
        } else {
            table = this.currentNetwork.getRow(this.currentObject).getTable();
            column = table.getColumn(columnName);
            row = table.getRow((Object)this.currentObject.getSUID());
        }
        if (column == null) {
            table.createColumn(columnName, attrTag.getDataType(), false);
        }
        try {
            Object value = attrTag.getObjectValue(finalString);
            row.set(columnName, value);
        }
        catch (Exception e) {
            logger.warn("Could not parse value: " + finalString, (Throwable)e);
        }
    }
}

