/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.table;

import java.util.function.Function;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.internal.base.CyViewBase;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;
import org.cytoscape.view.model.internal.table.CyTableViewImpl;
import org.cytoscape.view.model.table.CyColumnView;

public class CyColumnViewImpl
extends CyViewBase<CyColumn>
implements CyColumnView {
    private final CyTableViewImpl parent;

    public CyColumnViewImpl(CyTableViewImpl parent, CyColumn model) {
        super(model);
        this.parent = parent;
    }

    @Override
    public VPStore getVPStore() {
        return this.parent.columnVPs;
    }

    @Override
    public ViewLock getLock() {
        return this.parent.columnLock;
    }

    @Override
    public VisualLexicon getVisualLexicon() {
        return this.parent.getVisualLexicon();
    }

    public <T> void setCellVisualProperty(VisualProperty<? extends T> vp, Function<CyRow, T> mapping) {
        this.setVisualProperty(vp, mapping);
    }

    public <T> Function<CyRow, T> getCellVisualProperty(VisualProperty<? extends T> vp) {
        Object v = this.getVisualProperty(vp);
        if (v instanceof Function) {
            return (Function)v;
        }
        return row -> v;
    }

    @Override
    protected void fireViewChangedEvent(VisualProperty<?> vp, Object value, boolean lockedValue) {
        this.parent.addEventPayload(new ViewChangeRecord((View)this, vp, value, lockedValue));
    }
}

