/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network.snapshot;

import io.vavr.collection.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.network.snapshot.CyNetworkViewSnapshotImpl;

public abstract class CyViewSnapshotBase<M>
implements View<M> {
    private final Long suid;
    private Map<VisualProperty<?>, Object> visualProperties;
    private Map<VisualProperty<?>, Object> allLocks;
    private Map<VisualProperty<?>, Object> directLocks;

    public CyViewSnapshotBase(Long suid) {
        this.suid = suid;
    }

    public Long getSUID() {
        return this.suid;
    }

    public abstract CyNetworkViewSnapshotImpl getNetworkSnapshot();

    public abstract VPStore getVPStore();

    public Map<VisualProperty<?>, Object> getVisualPropertiesMap() {
        if (this.visualProperties == null) {
            this.visualProperties = this.getVPStore().getVisualPropertiesMap(this.suid);
        }
        return this.visualProperties;
    }

    public Map<VisualProperty<?>, Object> getAllLocksMap() {
        if (this.allLocks == null) {
            this.allLocks = this.getVPStore().getAllLocksMap(this.suid);
        }
        return this.allLocks;
    }

    public Map<VisualProperty<?>, Object> getDirectLocksMap() {
        if (this.directLocks == null) {
            this.directLocks = this.getVPStore().getDirectLocksMap(this.suid);
        }
        return this.directLocks;
    }

    protected <T> T getSpecialVisualProperty(Long suid, VisualProperty<T> vp) {
        return null;
    }

    public <T> T getVisualProperty(VisualProperty<T> vp) {
        Object value = this.getDirectLocksMap().getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        value = this.getAllLocksMap().getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        value = this.getSpecialVisualProperty(this.suid, vp);
        if (value != null) {
            return (T)value;
        }
        value = this.getVisualPropertiesMap().getOrElse(vp, null);
        if (value != null) {
            return (T)value;
        }
        return this.getNetworkSnapshot().getViewDefault(vp);
    }

    public boolean isSet(VisualProperty<?> vp) {
        if (this.getDirectLocksMap().containsKey(vp)) {
            return true;
        }
        if (this.getAllLocksMap().containsKey(vp)) {
            return true;
        }
        if (this.getSpecialVisualProperty(this.suid, vp) != null) {
            return true;
        }
        return this.getVisualPropertiesMap().containsKey(vp);
    }

    public boolean isValueLocked(VisualProperty<?> vp) {
        return this.getAllLocksMap().containsKey(vp);
    }

    public boolean isDirectlyLocked(VisualProperty<?> vp) {
        return this.getDirectLocksMap().containsKey(vp);
    }

    public <T, V extends T> void setVisualProperty(VisualProperty<? extends T> vp, V value) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public <T, V extends T> void setLockedValue(VisualProperty<? extends T> vp, V value) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public void clearValueLock(VisualProperty<?> vp) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public M getModel() {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public void clearVisualProperties() {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public void batch(Consumer<View<M>> viewConsumer) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public void batch(Consumer<View<M>> viewConsumer, boolean setDirty) {
        throw new UnsupportedOperationException("Cannot modify view snapshot");
    }

    public int hashCode() {
        return Objects.hash(this.suid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CyViewSnapshotBase other = (CyViewSnapshotBase)obj;
        return Objects.equals(this.suid, other.suid);
    }
}

