/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.model.internal.base.CyViewBase;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;
import org.cytoscape.view.model.internal.network.CyNetworkViewImpl;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyNodeViewImpl
extends CyViewBase<CyNode> {
    private final CyNetworkViewImpl netView;
    private boolean visible = true;

    public CyNodeViewImpl(CyNetworkViewImpl netView, CyNode model) {
        super(model);
        this.netView = netView;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setDirty() {
        this.netView.setDirty();
    }

    @Override
    public VPStore getVPStore() {
        return this.netView.nodeVPs;
    }

    @Override
    public ViewLock getLock() {
        return this.netView.nodeLock;
    }

    @Override
    public VisualLexicon getVisualLexicon() {
        return this.netView.getVisualLexicon();
    }

    @Override
    protected void fireViewChangedEvent(VisualProperty<?> vp, Object value, boolean lockedValue) {
        if (this.netView.isBVL() && vp == BasicVisualLexicon.NODE_VISIBLE) {
            boolean bl = this.visible = !Boolean.FALSE.equals(value);
            if (!this.visible) {
                this.netView.setElementHidden();
            }
        }
        ViewChangeRecord record = new ViewChangeRecord((View)this, vp, value, lockedValue);
        this.netView.getEventHelper().addEventPayload((Object)this.netView, (Object)record, ViewChangedEvent.class);
    }
}

