/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import org.cytoscape.model.CyEdge;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.model.internal.base.CyViewBase;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;
import org.cytoscape.view.model.internal.network.CyNetworkViewImpl;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyEdgeViewImpl
extends CyViewBase<CyEdge> {
    private final CyNetworkViewImpl netView;
    private final long sourceSuid;
    private final long targetSuid;
    private final boolean isDirected;
    private boolean visible = true;

    public CyEdgeViewImpl(CyNetworkViewImpl netView, CyEdge model, long sourceSuid, long targetSuid) {
        super(model);
        this.netView = netView;
        this.sourceSuid = sourceSuid;
        this.targetSuid = targetSuid;
        this.isDirected = model.isDirected();
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setDirty() {
        this.netView.setDirty();
    }

    public long getSourceSuid() {
        return this.sourceSuid;
    }

    public long getTargetSuid() {
        return this.targetSuid;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public VPStore getVPStore() {
        return this.netView.edgeVPs;
    }

    @Override
    public ViewLock getLock() {
        return this.netView.edgeLock;
    }

    @Override
    public VisualLexicon getVisualLexicon() {
        return this.netView.getVisualLexicon();
    }

    @Override
    protected void fireViewChangedEvent(VisualProperty<?> vp, Object value, boolean lockedValue) {
        if (this.netView.isBVL() && vp == BasicVisualLexicon.EDGE_VISIBLE) {
            boolean bl = this.visible = !Boolean.FALSE.equals(value);
            if (!this.visible) {
                this.netView.setElementHidden();
            }
        }
        ViewChangeRecord record = new ViewChangeRecord((View)this, vp, value, lockedValue);
        this.netView.getEventHelper().addEventPayload((Object)this.netView, (Object)record, ViewChangedEvent.class);
    }
}

