/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.base;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ViewLock
implements ReadWriteLock {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private int updateDirty = 0;
    private final ViewLock parent;

    public ViewLock() {
        this(null);
    }

    public ViewLock(ViewLock parent) {
        this.parent = parent;
    }

    public boolean isUpdateDirty() {
        return this.updateDirty == 0 && (this.parent == null || this.parent.isUpdateDirty());
    }

    public void enterBatch(Runnable runnable) {
        try {
            ++this.updateDirty;
            runnable.run();
        }
        finally {
            --this.updateDirty;
        }
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }
}

