/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.datasource.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.datasource.DataSource;
import org.cytoscape.io.datasource.DataSourceManager;

public final class DataSourceManagerImpl
implements DataSourceManager {
    private final Map<DataCategory, Map<String, DataSource>> dataSourceMap;
    private final Object lock = new Object();

    DataSourceManagerImpl() {
        this.dataSourceMap = new HashMap<DataCategory, Map<String, DataSource>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSource(DataSource datasource, Map<String, String> metadata) {
        if (datasource == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dataSourceMap.containsKey(datasource.getDataCategory())) {
                Map<String, DataSource> map = this.dataSourceMap.get(datasource.getDataCategory());
                map.put(datasource.getName(), datasource);
            } else {
                HashMap<String, DataSource> map = new HashMap<String, DataSource>();
                map.put(datasource.getName(), datasource);
                this.dataSourceMap.put(datasource.getDataCategory(), map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(DataSource datasource, Map<String, String> metadata) {
        if (datasource == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Map<String, DataSource> map = this.dataSourceMap.get(datasource.getDataCategory());
            if (map == null) {
                return;
            }
            map.remove(datasource.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataSource> getDataSources(DataCategory category) {
        Object object = this.lock;
        synchronized (object) {
            Collection<DataSource> values;
            LinkedHashSet<DataSource> set = new LinkedHashSet<DataSource>();
            if (this.dataSourceMap.get(category) != null && (values = this.dataSourceMap.get(category).values()) != null) {
                set.addAll(values);
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataSource> getDataSources(String providerName) {
        LinkedHashSet<DataSource> sources = new LinkedHashSet<DataSource>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<DataCategory> it = this.dataSourceMap.keySet().iterator();
            while (it.hasNext()) {
                Map<String, DataSource> map = this.dataSourceMap.get(it.next());
                for (DataSource ds : map.values()) {
                    if (!ds.getProvider().equals(providerName)) continue;
                    sources.add(ds);
                }
            }
            return sources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataSource> getAllDataSources() {
        HashSet<DataSource> sources = new HashSet<DataSource>();
        Object object = this.lock;
        synchronized (object) {
            Iterator<DataCategory> it = this.dataSourceMap.keySet().iterator();
            while (it.hasNext()) {
                sources.addAll(this.dataSourceMap.get(it.next()).values());
            }
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataCategory> getAllCategories() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<DataCategory>(this.dataSourceMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDataSource(DataSource pDataSource) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, DataSource> map = this.dataSourceMap.get(pDataSource.getDataCategory());
            if (map == null || map.get(pDataSource.getName()) == null) {
                return false;
            }
            map.remove(pDataSource.getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataSource(DataSource pDataSource) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, DataSource> map = this.dataSourceMap.get(pDataSource.getDataCategory());
            if (map == null) {
                map = new HashMap<String, DataSource>();
                this.dataSourceMap.put(pDataSource.getDataCategory(), map);
            }
            map.put(pDataSource.getName(), pDataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataSource(DataSource pDataSource) {
        Object object = this.lock;
        synchronized (object) {
            Collection<DataSource> dataSourcesSet = this.getDataSources(pDataSource.getDataCategory());
            if (dataSourcesSet == null || dataSourcesSet.size() == 0) {
                return false;
            }
            for (DataSource ds : dataSourcesSet) {
                if (!ds.getName().equalsIgnoreCase(pDataSource.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

